/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.metastore.iceberg.transform;

import java.lang.invoke.MethodHandle;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.drill.metastore.iceberg.exceptions.IcebergMetastoreException;
import org.apache.drill.metastore.iceberg.transform.WriteData;
import org.apache.iceberg.Schema;
import org.apache.iceberg.data.GenericRecord;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.types.Types;

public class InputDataTransformer<T> {
    private final Schema tableSchema;
    private final Schema partitionSpecSchema;
    private final Map<String, MethodHandle> unitGetters;
    private final List<T> units = new ArrayList<T>();

    public InputDataTransformer(Schema tableSchema, Schema partitionSpecSchema, Map<String, MethodHandle> unitGetters) {
        this.tableSchema = tableSchema;
        this.partitionSpecSchema = partitionSpecSchema;
        this.unitGetters = unitGetters;
    }

    public InputDataTransformer<T> units(List<T> units) {
        this.units.addAll(units);
        return this;
    }

    public WriteData execute() {
        ArrayList<Record> records = new ArrayList<Record>();
        HashSet<Record> partitions = new HashSet<Record>();
        for (T unit : this.units) {
            partitions.add(this.getPartition(unit, this.partitionSpecSchema, this.unitGetters));
            GenericRecord record = GenericRecord.create((Schema)this.tableSchema);
            for (Types.NestedField column : this.tableSchema.columns()) {
                String name = column.name();
                MethodHandle methodHandle = this.unitGetters.get(name);
                if (methodHandle == null) continue;
                try {
                    record.setField(name, methodHandle.invoke(unit));
                }
                catch (Throwable e) {
                    throw new IcebergMetastoreException(String.format("Unable to invoke getter for column [%s] using [%s]", name, methodHandle), e);
                }
            }
            records.add((Record)record);
        }
        if (partitions.size() > 1) {
            throw new IcebergMetastoreException(String.format("Partition keys values must be the same for all records in the partition. Partition schema: [%s]. Received partition values: %s", this.partitionSpecSchema, partitions));
        }
        return new WriteData(records, partitions.isEmpty() ? null : (Record)partitions.iterator().next());
    }

    private Record getPartition(T unit, Schema schema, Map<String, MethodHandle> unitGetters) {
        GenericRecord partitionRecord = GenericRecord.create((Schema)schema);
        for (Types.NestedField column : schema.columns()) {
            Object value;
            String name = column.name();
            MethodHandle methodHandle = unitGetters.get(name);
            if (methodHandle == null) {
                throw new IcebergMetastoreException(String.format("Getter for partition key [%s::%s] must be declared in [%s] class", name, column.type(), unit.getClass().getSimpleName()));
            }
            try {
                value = methodHandle.invoke(unit);
            }
            catch (Throwable e) {
                throw new IcebergMetastoreException(String.format("Unable to invoke getter for column [%s] using [%s]", name, methodHandle), e);
            }
            if (value == null) {
                throw new IcebergMetastoreException(String.format("Partition key [%s::%s] value must be set", name, column.type()));
            }
            partitionRecord.setField(name, value);
        }
        return partitionRecord;
    }
}

