/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.metastore.iceberg.transform;

import org.apache.drill.metastore.expressions.DoubleExpressionPredicate;
import org.apache.drill.metastore.expressions.FilterExpression;
import org.apache.drill.metastore.expressions.IsPredicate;
import org.apache.drill.metastore.expressions.ListPredicate;
import org.apache.drill.metastore.expressions.SimplePredicate;
import org.apache.drill.metastore.expressions.SingleExpressionPredicate;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;

public class FilterExpressionVisitor
implements FilterExpression.Visitor<Expression> {
    private static final FilterExpressionVisitor INSTANCE = new FilterExpressionVisitor();

    public static FilterExpression.Visitor<Expression> get() {
        return INSTANCE;
    }

    public Expression visit(SimplePredicate.Equal<?> expression) {
        return Expressions.equal((String)expression.column().columnName(), (Object)expression.value());
    }

    public Expression visit(SimplePredicate.NotEqual<?> expression) {
        return Expressions.notEqual((String)expression.column().columnName(), (Object)expression.value());
    }

    public Expression visit(SimplePredicate.LessThan<?> expression) {
        return Expressions.lessThan((String)expression.column().columnName(), (Object)expression.value());
    }

    public Expression visit(SimplePredicate.LessThanOrEqual<?> expression) {
        return Expressions.lessThanOrEqual((String)expression.column().columnName(), (Object)expression.value());
    }

    public Expression visit(SimplePredicate.GreaterThan<?> expression) {
        return Expressions.greaterThan((String)expression.column().columnName(), (Object)expression.value());
    }

    public Expression visit(SimplePredicate.GreaterThanOrEqual<?> expression) {
        return Expressions.greaterThanOrEqual((String)expression.column().columnName(), (Object)expression.value());
    }

    public Expression visit(ListPredicate.In<?> expression) {
        return Expressions.in((String)expression.column().columnName(), (Iterable)expression.values());
    }

    public Expression visit(ListPredicate.NotIn<?> expression) {
        return Expressions.notIn((String)expression.column().columnName(), (Iterable)expression.values());
    }

    public Expression visit(IsPredicate.IsNull expression) {
        return Expressions.isNull((String)expression.column().columnName());
    }

    public Expression visit(IsPredicate.IsNotNull expression) {
        return Expressions.notNull((String)expression.column().columnName());
    }

    public Expression visit(SingleExpressionPredicate.Not expression) {
        Expression child = (Expression)expression.expression().accept((FilterExpression.Visitor)this);
        return Expressions.not((Expression)child);
    }

    public Expression visit(DoubleExpressionPredicate.And expression) {
        Expression right = (Expression)expression.right().accept((FilterExpression.Visitor)this);
        Expression left = (Expression)expression.left().accept((FilterExpression.Visitor)this);
        return Expressions.and((Expression)right, (Expression)left);
    }

    public Expression visit(DoubleExpressionPredicate.Or expression) {
        Expression right = (Expression)expression.right().accept((FilterExpression.Visitor)this);
        Expression left = (Expression)expression.left().accept((FilterExpression.Visitor)this);
        return Expressions.or((Expression)right, (Expression)left);
    }
}

