/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.metastore.iceberg.components.tables;

import org.apache.drill.metastore.components.tables.TableMetadataUnit;
import org.apache.drill.metastore.iceberg.IcebergMetastoreContext;
import org.apache.drill.metastore.iceberg.components.tables.TablesOperationTransformer;
import org.apache.drill.metastore.iceberg.components.tables.TablesOutputDataTransformer;
import org.apache.drill.metastore.iceberg.transform.InputDataTransformer;
import org.apache.drill.metastore.iceberg.transform.OperationTransformer;
import org.apache.drill.metastore.iceberg.transform.OutputDataTransformer;
import org.apache.drill.metastore.iceberg.transform.Transformer;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;

public class TablesTransformer
implements Transformer<TableMetadataUnit> {
    private final IcebergMetastoreContext<TableMetadataUnit> context;

    public TablesTransformer(IcebergMetastoreContext<TableMetadataUnit> context) {
        this.context = context;
    }

    @Override
    public InputDataTransformer<TableMetadataUnit> inputData() {
        Table table = this.context.table();
        return new InputDataTransformer<TableMetadataUnit>(table.schema(), new Schema(table.spec().partitionType().fields()), TableMetadataUnit.SCHEMA.unitGetters());
    }

    @Override
    public OutputDataTransformer<TableMetadataUnit> outputData() {
        return new TablesOutputDataTransformer(TableMetadataUnit.SCHEMA.unitBuilderSetters());
    }

    @Override
    public OperationTransformer<TableMetadataUnit> operation() {
        return new TablesOperationTransformer(this.context);
    }
}

