/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.metastore.iceberg.components.tables;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.drill.metastore.MetastoreColumn;
import org.apache.drill.metastore.components.tables.TableMetadataUnit;
import org.apache.hadoop.fs.Path;

public class TableKey {
    private final String storagePlugin;
    private final String workspace;
    private final String tableName;

    public TableKey(String storagePlugin, String workspace, String tableName) {
        this.storagePlugin = storagePlugin;
        this.workspace = workspace;
        this.tableName = tableName;
    }

    public static TableKey of(TableMetadataUnit unit) {
        return new TableKey(unit.storagePlugin(), unit.workspace(), unit.tableName());
    }

    public String storagePlugin() {
        return this.storagePlugin;
    }

    public String workspace() {
        return this.workspace;
    }

    public String tableName() {
        return this.tableName;
    }

    public String toLocation(String base) {
        Path path = new Path(base);
        path = new Path(path, this.storagePlugin);
        path = new Path(path, this.workspace);
        path = new Path(path, this.tableName);
        return path.toUri().getPath();
    }

    public Map<MetastoreColumn, Object> toFilterConditions() {
        HashMap<MetastoreColumn, Object> conditions = new HashMap<MetastoreColumn, Object>();
        conditions.put(MetastoreColumn.STORAGE_PLUGIN, this.storagePlugin);
        conditions.put(MetastoreColumn.WORKSPACE, this.workspace);
        conditions.put(MetastoreColumn.TABLE_NAME, this.tableName);
        return conditions;
    }

    public int hashCode() {
        return Objects.hash(this.storagePlugin, this.workspace, this.tableName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableKey that = (TableKey)o;
        return Objects.equals(this.storagePlugin, that.storagePlugin) && Objects.equals(this.workspace, that.workspace) && Objects.equals(this.tableName, that.tableName);
    }
}

