/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff;

import io.protostuff.JsonXOutput;
import io.protostuff.LinkedBuffer;
import io.protostuff.Message;
import io.protostuff.Output;
import io.protostuff.Schema;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;

public final class JsonXIOUtil {
    private static final byte[] EMPTY_ARRAY = new byte[]{91, 93};

    public static <T> byte[] toByteArray(T message, Schema<T> schema, boolean numeric, LinkedBuffer buffer) {
        if (buffer.start != buffer.offset) {
            throw new IllegalArgumentException("Buffer previously used and had not been reset.");
        }
        JsonXOutput output = new JsonXOutput(buffer, numeric, schema);
        try {
            output.writeStartObject();
            schema.writeTo((Output)output, message);
            if (output.isLastRepeated()) {
                output.writeEndArray();
            }
            output.writeEndObject();
        }
        catch (IOException e) {
            throw new RuntimeException("Serializing to a byte array threw an IOException (should never happen).", e);
        }
        return output.toByteArray();
    }

    public static <T> void writeTo(LinkedBuffer buffer, T message, Schema<T> schema, boolean numeric) {
        if (buffer.start != buffer.offset) {
            throw new IllegalArgumentException("Buffer previously used and had not been reset.");
        }
        JsonXOutput output = new JsonXOutput(buffer, numeric, schema);
        try {
            output.writeStartObject();
            schema.writeTo((Output)output, message);
            if (output.isLastRepeated()) {
                output.writeEndArray();
            }
            output.writeEndObject();
        }
        catch (IOException e) {
            throw new RuntimeException("Serializing to a byte array threw an IOException (should never happen).", e);
        }
    }

    public static <T extends Message<T>> void writeTo(OutputStream out, T message, boolean numeric, LinkedBuffer buffer) throws IOException {
        JsonXIOUtil.writeTo(out, message, message.cachedSchema(), numeric, buffer);
    }

    public static <T> void writeTo(OutputStream out, T message, Schema<T> schema, boolean numeric, LinkedBuffer buffer) throws IOException {
        if (buffer.start != buffer.offset) {
            throw new IllegalArgumentException("Buffer previously used and had not been reset.");
        }
        JsonXOutput output = new JsonXOutput(buffer, out, numeric, schema);
        output.writeStartObject();
        schema.writeTo((Output)output, message);
        if (output.isLastRepeated()) {
            output.writeEndArray();
        }
        output.writeEndObject();
        LinkedBuffer.writeTo((OutputStream)out, (LinkedBuffer)buffer);
    }

    public static <T> void writeListTo(LinkedBuffer buffer, List<T> messages, Schema<T> schema, boolean numeric) {
        if (buffer.start != buffer.offset) {
            throw new IllegalArgumentException("Buffer previously used and had not been reset.");
        }
        if (messages.isEmpty()) {
            System.arraycopy(EMPTY_ARRAY, 0, buffer.buffer, buffer.offset, EMPTY_ARRAY.length);
            buffer.offset += EMPTY_ARRAY.length;
            return;
        }
        JsonXOutput output = new JsonXOutput(buffer, numeric, schema);
        try {
            output.writeStartArray();
            boolean first = true;
            for (T m : messages) {
                if (first) {
                    first = false;
                    output.writeStartObject();
                } else {
                    output.writeCommaAndStartObject();
                }
                schema.writeTo((Output)output, m);
                if (output.isLastRepeated()) {
                    output.writeEndArray();
                }
                output.writeEndObject().reset();
            }
            output.writeEndArray();
        }
        catch (IOException e) {
            throw new RuntimeException("Serializing to a byte array threw an IOException (should never happen).", e);
        }
    }

    public static <T> void writeListTo(OutputStream out, List<T> messages, Schema<T> schema, boolean numeric, LinkedBuffer buffer) throws IOException {
        if (buffer.start != buffer.offset) {
            throw new IllegalArgumentException("Buffer previously used and had not been reset.");
        }
        if (messages.isEmpty()) {
            System.arraycopy(EMPTY_ARRAY, 0, buffer.buffer, buffer.offset, EMPTY_ARRAY.length);
            buffer.offset += EMPTY_ARRAY.length;
            return;
        }
        JsonXOutput output = new JsonXOutput(buffer, out, numeric, schema);
        output.writeStartArray();
        boolean first = true;
        for (T m : messages) {
            if (first) {
                first = false;
                output.writeStartObject();
            } else {
                output.writeCommaAndStartObject();
            }
            schema.writeTo((Output)output, m);
            if (output.isLastRepeated()) {
                output.writeEndArray();
            }
            output.writeEndObject().reset();
        }
        output.writeEndArray();
        LinkedBuffer.writeTo((OutputStream)out, (LinkedBuffer)buffer);
    }
}

