/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf.object.datatype;

import io.jhdf.Utils;
import io.jhdf.dataset.DatasetReader;
import io.jhdf.exceptions.HdfException;
import io.jhdf.object.datatype.DataType;
import io.jhdf.storage.HdfBackingStorage;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import org.apache.commons.lang3.ArrayUtils;

public class ArrayDataType
extends DataType {
    private final DataType baseType;
    private final int[] dimensions;

    public ArrayDataType(ByteBuffer bb) {
        super(bb);
        int dimensionsSize = Utils.readBytesAsUnsignedInt(bb, 1);
        this.dimensions = new int[dimensionsSize];
        if (this.getVersion() == 2) {
            bb.position(bb.position() + 3);
        }
        for (int i = 0; i < this.dimensions.length; ++i) {
            this.dimensions[i] = Utils.readBytesAsUnsignedInt(bb, 4);
            if (this.getVersion() != 2) continue;
            bb.position(bb.position() + 4);
        }
        this.baseType = DataType.readDataType(bb);
    }

    @Override
    public Class<?> getJavaType() {
        return Array.newInstance(this.baseType.getJavaType(), 0).getClass();
    }

    public DataType getBaseType() {
        return this.baseType;
    }

    public int[] getDimensions() {
        return ArrayUtils.clone((int[])this.dimensions);
    }

    @Override
    public Object fillData(ByteBuffer buffer, int[] dimensions, HdfBackingStorage hdfBackingStorage) {
        if (dimensions.length != 1) {
            throw new HdfException("Multi dimension array data types are not supported");
        }
        Object data = Array.newInstance(this.getJavaType(), dimensions);
        for (int i = 0; i < dimensions[0]; ++i) {
            ByteBuffer elementBuffer = Utils.createSubBuffer(buffer, this.getBaseType().getSize() * this.getDimensions()[0]);
            Object elementDataset = DatasetReader.readDataset(this.getBaseType(), elementBuffer, this.getDimensions(), hdfBackingStorage);
            Array.set(data, i, elementDataset);
        }
        return data;
    }
}

