/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.hive.writers.complex;

import java.util.Map;
import org.apache.drill.exec.store.hive.writers.HiveValueWriter;
import org.apache.drill.exec.vector.complex.writer.BaseWriter;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;

public class HiveMapWriter
implements HiveValueWriter {
    private final MapObjectInspector mapInspector;
    private final BaseWriter.DictWriter dictWriter;
    private final HiveValueWriter keyWriter;
    private final HiveValueWriter valueWriter;

    public HiveMapWriter(MapObjectInspector mapInspector, BaseWriter.DictWriter dictWriter, HiveValueWriter keyWriter, HiveValueWriter valueWriter) {
        this.mapInspector = mapInspector;
        this.dictWriter = dictWriter;
        this.keyWriter = keyWriter;
        this.valueWriter = valueWriter;
    }

    @Override
    public void write(Object mapHolder) {
        Map map = this.mapInspector.getMap(mapHolder);
        if (map == null) {
            throw new UnsupportedOperationException("Null map is not supported in Hive.");
        }
        this.dictWriter.start();
        map.forEach((key, value) -> {
            if (key == null || value == null) {
                throw new UnsupportedOperationException("Null key or value are not supported in Hive maps.");
            }
            this.dictWriter.startKeyValuePair();
            this.keyWriter.write(key);
            this.valueWriter.write(value);
            this.dictWriter.endKeyValuePair();
        });
        this.dictWriter.end();
    }
}

