/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.hive.client;

import java.util.List;
import org.apache.drill.common.AutoCloseables;
import org.apache.drill.exec.store.hive.client.DrillHiveMetaStoreClient;
import org.apache.drill.shaded.guava.com.google.common.cache.CacheLoader;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DatabaseNameCacheLoader
extends CacheLoader<String, List<String>> {
    private static final Logger logger = LoggerFactory.getLogger(DatabaseNameCacheLoader.class);
    private final DrillHiveMetaStoreClient client;

    DatabaseNameCacheLoader(DrillHiveMetaStoreClient client) {
        this.client = client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> load(String key) throws Exception {
        DrillHiveMetaStoreClient drillHiveMetaStoreClient = this.client;
        synchronized (drillHiveMetaStoreClient) {
            try {
                return this.client.getAllDatabases();
            }
            catch (MetaException e) {
                logger.warn("Failure while attempting to get hive databases. Retries once.", (Throwable)e);
                AutoCloseable[] autoCloseableArray = new AutoCloseable[1];
                autoCloseableArray[0] = () -> ((DrillHiveMetaStoreClient)this.client).close();
                AutoCloseables.closeSilently((AutoCloseable[])autoCloseableArray);
                try {
                    this.client.reconnect();
                }
                catch (Exception e1) {
                    throw e;
                }
                return this.client.getAllDatabases();
            }
        }
    }
}

