/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl.hive;

import io.netty.buffer.DrillBuf;
import org.apache.drill.exec.expr.fn.impl.StringFunctionHelpers;
import org.apache.drill.exec.expr.fn.impl.hive.AbstractDrillPrimitiveObjectInspector;
import org.apache.drill.exec.expr.holders.NullableVarCharHolder;
import org.apache.drill.exec.expr.holders.VarCharHolder;
import org.apache.hadoop.hive.common.type.HiveVarchar;
import org.apache.hadoop.hive.serde2.io.HiveVarcharWritable;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveVarcharObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;

public class DrillVarCharHiveVarcharObjectInspector {

    public static class Optional
    extends AbstractDrillPrimitiveObjectInspector
    implements HiveVarcharObjectInspector {
        public Optional() {
            super(TypeInfoFactory.varcharTypeInfo);
        }

        public HiveVarcharWritable getPrimitiveWritableObject(Object o) {
            if (o == null) {
                return null;
            }
            NullableVarCharHolder h = (NullableVarCharHolder)o;
            HiveVarcharWritable valW = new HiveVarcharWritable();
            valW.set(StringFunctionHelpers.toStringFromUTF8((int)h.start, (int)h.end, (DrillBuf)h.buffer), 65535);
            return valW;
        }

        public HiveVarchar getPrimitiveJavaObject(Object o) {
            if (o == null) {
                return null;
            }
            NullableVarCharHolder h = (NullableVarCharHolder)o;
            String s = StringFunctionHelpers.toStringFromUTF8((int)h.start, (int)h.end, (DrillBuf)h.buffer);
            return new HiveVarchar(s, 65535);
        }
    }

    public static class Required
    extends AbstractDrillPrimitiveObjectInspector
    implements HiveVarcharObjectInspector {
        public Required() {
            super(TypeInfoFactory.varcharTypeInfo);
        }

        public HiveVarcharWritable getPrimitiveWritableObject(Object o) {
            VarCharHolder h = (VarCharHolder)o;
            HiveVarcharWritable valW = new HiveVarcharWritable();
            valW.set(StringFunctionHelpers.toStringFromUTF8((int)h.start, (int)h.end, (DrillBuf)h.buffer), 65535);
            return valW;
        }

        public HiveVarchar getPrimitiveJavaObject(Object o) {
            VarCharHolder h = (VarCharHolder)o;
            String s = StringFunctionHelpers.toStringFromUTF8((int)h.start, (int)h.end, (DrillBuf)h.buffer);
            return new HiveVarchar(s, 65535);
        }
    }
}

