/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.yarn.appMaster;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.drill.yarn.appMaster.AMException;
import org.apache.drill.yarn.appMaster.AMYarnFacade;
import org.apache.drill.yarn.appMaster.ClusterController;
import org.apache.drill.yarn.appMaster.ControllerVisitor;
import org.apache.drill.yarn.appMaster.EventContext;
import org.apache.drill.yarn.appMaster.NodeInventory;
import org.apache.drill.yarn.appMaster.Scheduler;
import org.apache.drill.yarn.appMaster.SchedulerStateActions;
import org.apache.drill.yarn.appMaster.SchedulerStateImpl;
import org.apache.drill.yarn.appMaster.Task;
import org.apache.drill.yarn.appMaster.TaskLifecycleListener;
import org.apache.drill.yarn.appMaster.TaskVisitor;
import org.apache.drill.yarn.appMaster.YarnFacadeException;
import org.apache.drill.yarn.core.DoYUtil;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterResponse;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.proto.YarnServiceProtos;

public class ClusterControllerImpl
implements ClusterController {
    private static final int PRIORITY_OFFSET = 1;
    private static final Log LOG = LogFactory.getLog(ClusterControllerImpl.class);
    private Object completionMutex = new Object();
    protected int maxRetries = 3;
    State state = State.START;
    private Map<String, SchedulerStateActions> taskPools = new HashMap<String, SchedulerStateActions>();
    private List<SchedulerStateActions> prioritizedGroups = new ArrayList<SchedulerStateActions>();
    private Set<ContainerId> allocatedContainers = new HashSet<ContainerId>();
    private Map<ContainerId, Task> activeContainers = new HashMap<ContainerId, Task>();
    private List<Task> completedTasks = new LinkedList<Task>();
    private final AMYarnFacade yarn;
    private int maxRequestsPerTick = 2;
    private int stopTimoutMs = 10000;
    private int configPollPeriod = 60000;
    private long nextResourcePollTime;
    private NodeInventory nodeInventory;
    private long lastFailureCheckTime;
    private int failureCheckPeriodMs = 60000;
    private int taskCheckPeriodMs = 10000;
    private long lastTaskCheckTime;
    private List<TaskLifecycleListener> lifecycleListeners = new ArrayList<TaskLifecycleListener>();
    private Map<String, Object> properties = new HashMap<String, Object>();
    private boolean enableFailureCheck = true;

    public ClusterControllerImpl(AMYarnFacade yarn) {
        this.yarn = yarn;
    }

    @Override
    public void enableFailureCheck(boolean flag) {
        this.enableFailureCheck = flag;
    }

    @Override
    public void registerScheduler(Scheduler scheduler) {
        assert (!this.taskPools.containsKey(scheduler.getName()));
        scheduler.setPriority(this.taskPools.size() + 1);
        SchedulerStateImpl taskGroup = new SchedulerStateImpl(this, scheduler);
        this.taskPools.put(taskGroup.getName(), taskGroup);
        this.prioritizedGroups.add(taskGroup);
    }

    @Override
    public synchronized void started() throws YarnFacadeException, AMException {
        this.nodeInventory = new NodeInventory(this.yarn);
        Resource maxResource = this.yarn.getRegistrationResponse().getMaximumResourceCapability();
        for (SchedulerStateActions group : this.prioritizedGroups) {
            group.getScheduler().limitContainerSize(maxResource);
        }
        this.state = State.LIVE;
    }

    @Override
    public synchronized void tick(long curTime) {
        if (this.state == State.LIVE) {
            this.adjustTasks(curTime);
            this.requestContainers();
        }
        if (this.state == State.LIVE || this.state == State.ENDING) {
            this.checkTasks(curTime);
        }
    }

    private void adjustTasks(long curTime) {
        if (this.enableFailureCheck && this.getFreeNodeCount() == 0) {
            this.checkForFailure(curTime);
        }
        if (this.state != State.LIVE) {
            return;
        }
        for (SchedulerStateActions group : this.prioritizedGroups) {
            group.adjustTasks();
        }
    }

    @Override
    public int getFreeNodeCount() {
        int count = this.nodeInventory.getFreeNodeCount();
        for (SchedulerStateActions group : this.prioritizedGroups) {
            count -= group.getRequestCount();
        }
        return Math.max(0, count);
    }

    private void checkForFailure(long curTime) {
        if (this.lastFailureCheckTime + (long)this.failureCheckPeriodMs > curTime) {
            return;
        }
        this.lastFailureCheckTime = curTime;
        for (SchedulerStateActions group : this.prioritizedGroups) {
            if (group.getTaskCount() <= 0) continue;
            return;
        }
        LOG.error((Object)"Application failure: no tasks are running and no nodes are available -- exiting.");
        this.terminate(State.FAILED);
    }

    private void checkTasks(long curTime) {
        if (this.lastTaskCheckTime + (long)this.taskCheckPeriodMs > curTime) {
            return;
        }
        this.lastTaskCheckTime = curTime;
        EventContext context = new EventContext(this);
        for (SchedulerStateActions group : this.prioritizedGroups) {
            context.setGroup(group);
            group.checkTasks(context, curTime);
        }
    }

    @Override
    public void updateRMStatus() {
        long curTime = System.currentTimeMillis();
        if (this.nextResourcePollTime > curTime) {
            return;
        }
        this.nextResourcePollTime = curTime + (long)this.configPollPeriod;
    }

    private void requestContainers() {
        EventContext context = new EventContext(this);
        for (SchedulerStateActions group : this.prioritizedGroups) {
            context.setGroup(group);
            if (!group.requestContainers(context, this.maxRequestsPerTick)) continue;
            break;
        }
    }

    @Override
    public synchronized void containersAllocated(List<Container> containers) {
        EventContext context = new EventContext(this);
        for (Container container : containers) {
            if (this.allocatedContainers.contains(container.getId())) continue;
            String host = container.getNodeId().getHost();
            if (this.nodeInventory.isInUse(host)) {
                LOG.error((Object)("Host is in use, but YARN allocated a container: " + DoYUtil.labelContainer(container) + " - container rejected."));
                this.yarn.releaseContainer(container);
                continue;
            }
            this.allocatedContainers.add(container.getId());
            int priority = container.getPriority().getPriority();
            int offset = priority - 1;
            if (offset < 0 || offset > this.prioritizedGroups.size()) {
                LOG.error((Object)("Container allocated with unknown priority " + DoYUtil.labelContainer(container)));
                continue;
            }
            context.setGroup(this.prioritizedGroups.get(offset));
            context.group.containerAllocated(context, container);
        }
    }

    @Override
    public synchronized void containerStarted(ContainerId containerId) {
        Task task = this.getTask(containerId);
        if (task == null) {
            return;
        }
        EventContext context = new EventContext(this, task);
        context.getState().containerStarted(context);
        LOG.trace((Object)("Container started: " + containerId));
    }

    @Override
    public synchronized void taskStartFailed(ContainerId containerId, Throwable t) {
        Task task = this.getTask(containerId);
        if (task == null) {
            return;
        }
        EventContext context = new EventContext(this, task);
        context.getState().launchFailed(context, t);
    }

    private Task getTask(ContainerId containerId) {
        return this.activeContainers.get(containerId);
    }

    @Override
    public synchronized void containerStopped(ContainerId containerId) {
    }

    @Override
    public synchronized void containersCompleted(List<ContainerStatus> statuses) {
        EventContext context = new EventContext(this);
        for (ContainerStatus status : statuses) {
            Task task = this.getTask(status.getContainerId());
            if (task == null) {
                if (task != null) continue;
                LOG.warn((Object)("Container completed but no associated task state: " + status.getContainerId()));
                continue;
            }
            context.setTask(task);
            context.getState().containerCompleted(context, status);
        }
        this.checkStatus();
    }

    @Override
    public synchronized float getProgress() {
        int numerator = 0;
        int denominator = 0;
        for (SchedulerStateActions group : this.taskPools.values()) {
            Scheduler sched = group.getScheduler();
            int[] progress = sched.getProgress();
            numerator += progress[0];
            denominator += progress[1];
        }
        if (numerator == 0) {
            return 1.0f;
        }
        return (float)denominator / (float)numerator;
    }

    @Override
    public synchronized void stopTaskFailed(ContainerId containerId, Throwable t) {
        Task task = this.getTask(containerId);
        if (task == null) {
            return;
        }
        EventContext context = new EventContext(this, task);
        context.getState().stopTaskFailed(context, t);
    }

    @Override
    public synchronized void resizeDelta(int delta) {
        this.prioritizedGroups.get(0).getScheduler().change(delta);
    }

    @Override
    public synchronized int resizeTo(int n) {
        return this.prioritizedGroups.get(0).getScheduler().resize(n);
    }

    @Override
    public synchronized void shutDown() {
        LOG.info((Object)"Shut down request received");
        this.state = State.ENDING;
        EventContext context = new EventContext(this);
        for (SchedulerStateActions group : this.prioritizedGroups) {
            group.shutDown(context);
        }
        this.checkStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean waitForCompletion() {
        this.start();
        Object object = this.completionMutex;
        synchronized (object) {
            try {
                this.completionMutex.wait();
                LOG.info((Object)"Controller shut down completed");
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return this.succeeded();
    }

    private void start() {
        this.yarnReport();
    }

    private void yarnReport() {
        RegisterApplicationMasterResponse response = this.yarn.getRegistrationResponse();
        LOG.info((Object)("YARN queue: " + response.getQueue()));
        Resource resource = response.getMaximumResourceCapability();
        LOG.info((Object)("YARN max resource: " + resource.getMemory() + " MB, " + resource.getVirtualCores() + " cores"));
        EnumSet types = response.getSchedulerResourceTypes();
        StringBuilder buf = new StringBuilder();
        String sep = "";
        for (YarnServiceProtos.SchedulerResourceTypes type : types) {
            buf.append(sep);
            buf.append(type.toString());
            sep = ", ";
        }
        LOG.info((Object)("YARN scheduler resource types: " + buf.toString()));
    }

    private void checkStatus() {
        if (this.state != State.ENDING) {
            return;
        }
        for (SchedulerStateActions group : this.prioritizedGroups) {
            if (group.isDone()) continue;
            return;
        }
        this.terminate(State.ENDED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void terminate(State state) {
        this.state = state;
        Object object = this.completionMutex;
        synchronized (object) {
            this.completionMutex.notify();
        }
    }

    public boolean isLive() {
        return this.state == State.LIVE;
    }

    public boolean succeeded() {
        return this.state == State.ENDED;
    }

    public void containerAllocated(Task task) {
        this.activeContainers.put(task.getContainerId(), task);
    }

    public AMYarnFacade getYarn() {
        return this.yarn;
    }

    public void containerReleased(Task task) {
        this.activeContainers.remove(task.getContainerId());
    }

    public void taskEnded(Task task) {
        this.completedTasks.add(task);
    }

    public void taskRetried(Task task) {
        Task copy = task.copy();
        copy.disposition = Task.Disposition.RETRIED;
        this.completedTasks.add(copy);
    }

    public void taskGroupCompleted(SchedulerStateActions taskGroup) {
        this.checkStatus();
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public int getStopTimeoutMs() {
        return this.stopTimoutMs;
    }

    @Override
    public synchronized void reserveHost(String hostName) {
        this.nodeInventory.reserve(hostName);
    }

    @Override
    public synchronized void releaseHost(String hostName) {
        this.nodeInventory.release(hostName);
    }

    public NodeInventory getNodeInventory() {
        return this.nodeInventory;
    }

    @Override
    public void setProperty(String key, Object value) {
        this.properties.put(key, value);
    }

    @Override
    public Object getProperty(String key) {
        return this.properties.get(key);
    }

    @Override
    public void registerLifecycleListener(TaskLifecycleListener listener) {
        this.lifecycleListeners.add(listener);
    }

    public void fireLifecycleChange(TaskLifecycleListener.Event event, EventContext context) {
        for (TaskLifecycleListener listener : this.lifecycleListeners) {
            listener.stateChange(event, context);
        }
    }

    @Override
    public void setMaxRetries(int value) {
        this.maxRetries = value;
    }

    @Override
    public int getTargetCount() {
        int count = 0;
        for (SchedulerStateActions group : this.prioritizedGroups) {
            count += group.getScheduler().getTarget();
        }
        return count;
    }

    public State getState() {
        return this.state;
    }

    @Override
    public synchronized void visit(ControllerVisitor visitor) {
        visitor.visit(this);
    }

    public List<SchedulerStateActions> getPools() {
        return this.prioritizedGroups;
    }

    @Override
    public synchronized void visitTasks(TaskVisitor visitor) {
        for (SchedulerStateActions pool : this.prioritizedGroups) {
            pool.visitTaskModels(visitor);
        }
    }

    public List<Task> getHistory() {
        return this.completedTasks;
    }

    @Override
    public boolean isTaskLive(int id) {
        for (SchedulerStateActions group : this.prioritizedGroups) {
            Task task = group.getTask(id);
            if (task == null) continue;
            return task.isLive();
        }
        return false;
    }

    @Override
    public synchronized boolean cancelTask(int id) {
        for (SchedulerStateActions group : this.prioritizedGroups) {
            Task task = group.getTask(id);
            if (task == null) continue;
            group.cancel(task);
            group.getScheduler().change(-1);
            return true;
        }
        LOG.warn((Object)("Requested to cancel task, but no task found: " + id));
        return false;
    }

    @Override
    public synchronized void completionAck(Task task, String propertyKey) {
        EventContext context = new EventContext(this);
        context.setTask(task);
        context.getState().completionAck(context);
        if (propertyKey != null) {
            task.properties.remove(propertyKey);
        }
    }

    @Override
    public synchronized void startAck(Task task, String propertyKey, Object value) {
        if (propertyKey != null && value != null) {
            task.properties.put(propertyKey, value);
        }
        EventContext context = new EventContext(this);
        context.setTask(task);
        context.getState().startAck(context);
    }

    @Override
    public boolean supportsDiskResource() {
        return this.getYarn().supportsDiskResource();
    }

    @Override
    public void registryDown() {
        this.shutDown();
    }

    public static enum State {
        START,
        LIVE,
        ENDING,
        ENDED,
        FAILED;

    }
}

