/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.druid.rest;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.drill.exec.store.druid.rest.RestClient;

public class RestClientWrapper
implements RestClient {
    private final OkHttpClient httpClient = new OkHttpClient();

    @Override
    public Response get(String url) throws IOException {
        Request get = new Request.Builder().url(url).addHeader("Content-Type", "application/json").build();
        return this.httpClient.newCall(get).execute();
    }

    @Override
    public Response post(String url, String body) throws IOException {
        RequestBody postBody = RequestBody.create((byte[])body.getBytes(StandardCharsets.UTF_8));
        Request post = new Request.Builder().url(url).addHeader("Content-Type", "application/json").post(postBody).build();
        return this.httpClient.newCall(post).execute();
    }
}

