/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.delta.snapshot;

import org.apache.drill.exec.store.delta.snapshot.DeltaLatestSnapshot;
import org.apache.drill.exec.store.delta.snapshot.DeltaSnapshot;
import org.apache.drill.exec.store.delta.snapshot.DeltaSnapshotByTimestamp;
import org.apache.drill.exec.store.delta.snapshot.DeltaSnapshotByVersion;

public class DeltaSnapshotFactory {
    public static final DeltaSnapshotFactory INSTANCE = new DeltaSnapshotFactory();

    public DeltaSnapshot create(SnapshotContext context) {
        if (context.getSnapshotAsOfVersion() != null) {
            return new DeltaSnapshotByVersion(context.getSnapshotAsOfVersion());
        }
        if (context.getSnapshotAsOfTimestamp() != null) {
            return new DeltaSnapshotByTimestamp(context.getSnapshotAsOfTimestamp());
        }
        return DeltaLatestSnapshot.INSTANCE;
    }

    public static class SnapshotContext {
        private final Long snapshotAsOfVersion;
        private final Long snapshotAsOfTimestamp;

        SnapshotContext(SnapshotContextBuilder builder) {
            this.snapshotAsOfVersion = builder.snapshotAsOfVersion;
            this.snapshotAsOfTimestamp = builder.snapshotAsOfTimestamp;
        }

        public static SnapshotContextBuilder builder() {
            return new SnapshotContextBuilder();
        }

        public Long getSnapshotAsOfVersion() {
            return this.snapshotAsOfVersion;
        }

        public Long getSnapshotAsOfTimestamp() {
            return this.snapshotAsOfTimestamp;
        }

        public static class SnapshotContextBuilder {
            private Long snapshotAsOfVersion;
            private Long snapshotAsOfTimestamp;

            public SnapshotContextBuilder snapshotAsOfVersion(Long snapshotAsOfVersion) {
                this.snapshotAsOfVersion = snapshotAsOfVersion;
                return this;
            }

            public SnapshotContextBuilder snapshotAsOfTimestamp(Long snapshotAsOfTime) {
                this.snapshotAsOfTimestamp = snapshotAsOfTime;
                return this;
            }

            public SnapshotContext build() {
                return new SnapshotContext(this);
            }
        }
    }
}

