/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.delta.plan;

import io.delta.standalone.expressions.And;
import io.delta.standalone.expressions.EqualTo;
import io.delta.standalone.expressions.Expression;
import io.delta.standalone.expressions.GreaterThan;
import io.delta.standalone.expressions.GreaterThanOrEqual;
import io.delta.standalone.expressions.IsNotNull;
import io.delta.standalone.expressions.IsNull;
import io.delta.standalone.expressions.LessThan;
import io.delta.standalone.expressions.LessThanOrEqual;
import io.delta.standalone.expressions.Literal;
import io.delta.standalone.expressions.Not;
import io.delta.standalone.expressions.Or;
import io.delta.standalone.expressions.Predicate;
import io.delta.standalone.types.StructType;
import java.math.BigDecimal;
import org.apache.drill.common.expression.FunctionCall;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.expression.PathSegment;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.expression.ValueExpressions;
import org.apache.drill.common.expression.visitors.AbstractExprVisitor;
import org.apache.drill.common.expression.visitors.ExprVisitor;

public class DrillExprToDeltaTranslator
extends AbstractExprVisitor<Expression, Void, RuntimeException> {
    private final StructType structType;

    public DrillExprToDeltaTranslator(StructType structType) {
        this.structType = structType;
    }

    public Expression visitFunctionCall(FunctionCall call, Void value) {
        try {
            return this.visitFunctionCall(call);
        }
        catch (Exception e) {
            return null;
        }
    }

    private Predicate visitFunctionCall(FunctionCall call) {
        switch (call.getName()) {
            case "booleanAnd": {
                Expression left = (Expression)call.arg(0).accept((ExprVisitor)this, null);
                Expression right = (Expression)call.arg(1).accept((ExprVisitor)this, null);
                if (left != null && right != null) {
                    return new And(left, right);
                }
                return null;
            }
            case "booleanOr": {
                Expression left = (Expression)call.arg(0).accept((ExprVisitor)this, null);
                Expression right = (Expression)call.arg(1).accept((ExprVisitor)this, null);
                if (left != null && right != null) {
                    return new Or(left, right);
                }
                return null;
            }
            case "not": {
                Expression expression = (Expression)call.arg(0).accept((ExprVisitor)this, null);
                if (expression != null) {
                    return new Not(expression);
                }
                return null;
            }
            case "isnull": {
                LogicalExpression arg = call.arg(0);
                if (arg instanceof SchemaPath) {
                    String name = DrillExprToDeltaTranslator.getPath((SchemaPath)arg);
                    return new IsNull((Expression)this.structType.column(name));
                }
                return null;
            }
            case "isnotnull": {
                LogicalExpression arg = call.arg(0);
                if (arg instanceof SchemaPath) {
                    String name = DrillExprToDeltaTranslator.getPath((SchemaPath)arg);
                    return new IsNotNull((Expression)this.structType.column(name));
                }
                return null;
            }
            case "less_than": {
                LogicalExpression nameRef = call.arg(0);
                Expression expression = (Expression)call.arg(1).accept((ExprVisitor)this, null);
                if (nameRef instanceof SchemaPath) {
                    String name = DrillExprToDeltaTranslator.getPath((SchemaPath)nameRef);
                    return new LessThan((Expression)this.structType.column(name), expression);
                }
                return null;
            }
            case "less_than_or_equal_to": {
                LogicalExpression nameRef = call.arg(0);
                Expression expression = (Expression)call.arg(1).accept((ExprVisitor)this, null);
                if (nameRef instanceof SchemaPath) {
                    String name = DrillExprToDeltaTranslator.getPath((SchemaPath)nameRef);
                    return new LessThanOrEqual((Expression)this.structType.column(name), expression);
                }
                return null;
            }
            case "greater_than": {
                LogicalExpression nameRef = (LogicalExpression)call.args().get(0);
                Expression expression = (Expression)((LogicalExpression)call.args().get(1)).accept((ExprVisitor)this, null);
                if (nameRef instanceof SchemaPath) {
                    String name = DrillExprToDeltaTranslator.getPath((SchemaPath)nameRef);
                    return new GreaterThan((Expression)this.structType.column(name), expression);
                }
                return null;
            }
            case "greater_than_or_equal_to": {
                LogicalExpression nameRef = (LogicalExpression)call.args().get(0);
                Expression expression = (Expression)((LogicalExpression)call.args().get(0)).accept((ExprVisitor)this, null);
                if (nameRef instanceof SchemaPath) {
                    String name = DrillExprToDeltaTranslator.getPath((SchemaPath)nameRef);
                    return new GreaterThanOrEqual((Expression)this.structType.column(name), expression);
                }
                return null;
            }
            case "equal": {
                LogicalExpression nameRef = (LogicalExpression)call.args().get(0);
                Expression expression = (Expression)((LogicalExpression)call.args().get(1)).accept((ExprVisitor)this, null);
                if (nameRef instanceof SchemaPath) {
                    String name = DrillExprToDeltaTranslator.getPath((SchemaPath)nameRef);
                    return new EqualTo((Expression)this.structType.column(name), expression);
                }
                return null;
            }
            case "not_equal": {
                LogicalExpression nameRef = (LogicalExpression)call.args().get(0);
                Expression expression = (Expression)((LogicalExpression)call.args().get(1)).accept((ExprVisitor)this, null);
                if (nameRef instanceof SchemaPath) {
                    String name = DrillExprToDeltaTranslator.getPath((SchemaPath)nameRef);
                    return new Not((Expression)new EqualTo((Expression)this.structType.column(name), expression));
                }
                return null;
            }
        }
        return null;
    }

    public Expression visitFloatConstant(ValueExpressions.FloatExpression fExpr, Void value) {
        return Literal.of((float)fExpr.getFloat());
    }

    public Expression visitIntConstant(ValueExpressions.IntExpression intExpr, Void value) {
        return Literal.of((int)intExpr.getInt());
    }

    public Expression visitLongConstant(ValueExpressions.LongExpression longExpr, Void value) {
        return Literal.of((long)longExpr.getLong());
    }

    public Expression visitDecimal9Constant(ValueExpressions.Decimal9Expression decExpr, Void value) {
        return Literal.of((int)decExpr.getIntFromDecimal());
    }

    public Expression visitDecimal18Constant(ValueExpressions.Decimal18Expression decExpr, Void value) {
        return Literal.of((long)decExpr.getLongFromDecimal());
    }

    public Expression visitDecimal28Constant(ValueExpressions.Decimal28Expression decExpr, Void value) {
        return Literal.of((BigDecimal)decExpr.getBigDecimal());
    }

    public Expression visitDecimal38Constant(ValueExpressions.Decimal38Expression decExpr, Void value) {
        return Literal.of((BigDecimal)decExpr.getBigDecimal());
    }

    public Expression visitVarDecimalConstant(ValueExpressions.VarDecimalExpression decExpr, Void value) {
        return Literal.of((BigDecimal)decExpr.getBigDecimal());
    }

    public Expression visitDateConstant(ValueExpressions.DateExpression dateExpr, Void value) {
        return Literal.of((long)dateExpr.getDate());
    }

    public Expression visitTimeConstant(ValueExpressions.TimeExpression timeExpr, Void value) {
        return Literal.of((int)timeExpr.getTime());
    }

    public Expression visitTimeStampConstant(ValueExpressions.TimeStampExpression timestampExpr, Void value) {
        return Literal.of((long)timestampExpr.getTimeStamp());
    }

    public Expression visitDoubleConstant(ValueExpressions.DoubleExpression dExpr, Void value) {
        return Literal.of((double)dExpr.getDouble());
    }

    public Expression visitBooleanConstant(ValueExpressions.BooleanExpression e, Void value) {
        return Literal.of((boolean)e.getBoolean());
    }

    public Expression visitQuotedStringConstant(ValueExpressions.QuotedString e, Void value) {
        return Literal.of((String)e.getString());
    }

    public Expression visitUnknown(LogicalExpression e, Void value) {
        return null;
    }

    private static String getPath(SchemaPath schemaPath) {
        StringBuilder sb = new StringBuilder();
        PathSegment.NameSegment segment = schemaPath.getRootSegment();
        sb.append(segment.getNameSegment().getPath());
        while ((segment = segment.getChild()) != null) {
            sb.append('.').append(segment.isNamed() ? segment.getNameSegment().getPath() : "element");
        }
        return sb.toString();
    }
}

