/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxAPIException;
import com.box.sdk.BoxAPIRequest;
import com.box.sdk.BoxAPIResponse;
import com.box.sdk.BoxJSONResponse;
import com.box.sdk.BoxZipDownloadStatus;
import com.box.sdk.BoxZipInfo;
import com.box.sdk.BoxZipItem;
import com.box.sdk.ProgressListener;
import com.box.sdk.URLTemplate;
import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.List;

public class BoxZip {
    public static final URLTemplate ZIP_URL_TEMPLATE = new URLTemplate("zip_downloads");
    public static final URLTemplate ZIP_DOWNLOAD_URL_TEMPLATE = new URLTemplate("zip_downloads/%s/content");
    private static final int BUFFER_SIZE = 8192;
    private final BoxAPIConnection api;

    public BoxZip(BoxAPIConnection api) {
        this.api = api;
    }

    public BoxZipInfo create(String name, List<BoxZipItem> items) {
        JsonArray itemsArray = new JsonArray();
        for (BoxZipItem item : items) {
            itemsArray.add((JsonValue)item.getJSONObject());
        }
        JsonObject requestJSON = new JsonObject();
        requestJSON.add("items", (JsonValue)itemsArray);
        requestJSON.add("download_file_name", name);
        URL url = ZIP_URL_TEMPLATE.build(this.getAPI().getBaseURL(), new Object[0]);
        BoxAPIRequest request = new BoxAPIRequest(this.getAPI(), url, "POST");
        request.setBody(requestJSON.toString());
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject responseJSON = Json.parse((String)response.getJSON()).asObject();
        return new BoxZipInfo(responseJSON);
    }

    public BoxZipDownloadStatus download(String name, List<BoxZipItem> items, OutputStream output) {
        return this.download(name, items, output, null);
    }

    public BoxZipDownloadStatus download(String name, List<BoxZipItem> items, OutputStream output, ProgressListener listener) {
        BoxZipInfo zipInfo = this.create(name, items);
        BoxAPIRequest request = new BoxAPIRequest(this.getAPI(), zipInfo.getDownloadURL(), "GET");
        BoxAPIResponse response = request.send();
        InputStream input = response.getBody(listener);
        byte[] buffer = new byte[8192];
        try {
            int n = input.read(buffer);
            while (n != -1) {
                output.write(buffer, 0, n);
                n = input.read(buffer);
            }
        }
        catch (IOException e) {
            throw new BoxAPIException("Couldn't connect to the Box API due to a network error.", e);
        }
        finally {
            response.disconnect();
        }
        BoxAPIRequest statusRequest = new BoxAPIRequest(this.getAPI(), zipInfo.getStatusURL(), "GET");
        BoxJSONResponse statusResponse = (BoxJSONResponse)statusRequest.send();
        JsonObject statusResponseJSON = Json.parse((String)statusResponse.getJSON()).asObject();
        return new BoxZipDownloadStatus(statusResponseJSON);
    }

    public BoxAPIConnection getAPI() {
        return this.api;
    }
}

