/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.kafka;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.exec.store.kafka.KafkaPartitionScanSpec;
import org.apache.drill.shaded.guava.com.google.common.base.Stopwatch;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageIterator
implements Iterator<ConsumerRecord<byte[], byte[]>>,
AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(MessageIterator.class);
    private final KafkaConsumer<byte[], byte[]> kafkaConsumer;
    private Iterator<ConsumerRecord<byte[], byte[]>> recordIter;
    private final TopicPartition topicPartition;
    private long totalFetchTime = 0L;
    private final long kafkaPollTimeOut;
    private final long endOffset;

    public MessageIterator(KafkaConsumer<byte[], byte[]> kafkaConsumer, KafkaPartitionScanSpec subScanSpec, long kafkaPollTimeOut) {
        this.kafkaConsumer = kafkaConsumer;
        this.kafkaPollTimeOut = kafkaPollTimeOut;
        ArrayList<TopicPartition> partitions = new ArrayList<TopicPartition>(1);
        this.topicPartition = new TopicPartition(subScanSpec.getTopicName(), subScanSpec.getPartitionId());
        partitions.add(this.topicPartition);
        this.kafkaConsumer.assign(partitions);
        logger.debug("Start offset of {}:{} is - {}", new Object[]{subScanSpec.getTopicName(), subScanSpec.getPartitionId(), subScanSpec.getStartOffset()});
        this.kafkaConsumer.seek(this.topicPartition, subScanSpec.getStartOffset());
        this.endOffset = subScanSpec.getEndOffset();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Does not support remove operation");
    }

    @Override
    public boolean hasNext() {
        ConsumerRecords consumerRecords;
        if (this.recordIter != null && this.recordIter.hasNext()) {
            return true;
        }
        long nextPosition = this.kafkaConsumer.position(this.topicPartition);
        if (nextPosition >= this.endOffset) {
            return false;
        }
        Stopwatch stopwatch = logger.isDebugEnabled() ? Stopwatch.createStarted() : null;
        try {
            consumerRecords = this.kafkaConsumer.poll(Duration.ofMillis(this.kafkaPollTimeOut));
        }
        catch (KafkaException ke) {
            throw UserException.dataReadError((Throwable)ke).message(ke.getMessage(), new Object[0]).build(logger);
        }
        finally {
            if (stopwatch != null) {
                stopwatch.stop();
            }
        }
        if (consumerRecords.isEmpty()) {
            throw UserException.dataReadError().message("Failed to fetch messages within %s milliseconds. Consider increasing the value of the property: %s", new Object[]{this.kafkaPollTimeOut, "store.kafka.poll.timeout"}).build(logger);
        }
        if (stopwatch != null) {
            long lastFetchTime = stopwatch.elapsed(TimeUnit.MILLISECONDS);
            logger.debug("Time taken to fetch : {} milliseconds", (Object)lastFetchTime);
            this.totalFetchTime += lastFetchTime;
            logger.debug("Total number of messages fetched : {}", (Object)consumerRecords.count());
        }
        this.recordIter = consumerRecords.iterator();
        return this.recordIter.hasNext();
    }

    public long getTotalFetchTime() {
        return this.totalFetchTime;
    }

    @Override
    public ConsumerRecord<byte[], byte[]> next() {
        return this.recordIter.next();
    }

    @Override
    public void close() {
        this.kafkaConsumer.close();
    }
}

