/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.iceberg.read;

import java.util.Iterator;
import org.apache.drill.common.AutoCloseables;
import org.apache.drill.exec.physical.impl.scan.framework.ManagedReader;
import org.apache.drill.exec.physical.impl.scan.framework.SchemaNegotiator;
import org.apache.drill.exec.physical.impl.scan.v3.FixedReceiver;
import org.apache.drill.exec.physical.resultSet.ResultSetLoader;
import org.apache.drill.exec.physical.resultSet.RowSetLoader;
import org.apache.drill.exec.record.ColumnConverter;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.apache.drill.exec.record.metadata.TupleSchema;
import org.apache.drill.exec.store.iceberg.IcebergWork;
import org.apache.drill.exec.store.iceberg.read.IcebergColumnConverterFactory;
import org.apache.drill.exec.vector.accessor.TupleWriter;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.data.ScanTaskTableScanIterable;
import org.apache.iceberg.io.CloseableIterable;

public class IcebergRecordReader
implements ManagedReader<SchemaNegotiator> {
    private final IcebergWork work;
    private final TableScan tableScan;
    private final int maxRecords;
    private ResultSetLoader loader;
    private Iterator<Record> records;
    private ColumnConverter converter;
    private CloseableIterable<Record> taskToClose;

    public IcebergRecordReader(TableScan tableScan, IcebergWork work, int maxRecords) {
        this.work = work;
        this.tableScan = tableScan;
        this.maxRecords = maxRecords;
    }

    public boolean open(SchemaNegotiator negotiator) {
        TupleSchema tableSchema = new TupleSchema();
        this.tableScan.schema().columns().stream().map(IcebergColumnConverterFactory::getColumnMetadata).forEach(arg_0 -> ((TupleSchema)tableSchema).add(arg_0));
        TupleMetadata providedSchema = negotiator.providedSchema();
        TupleMetadata tupleSchema = FixedReceiver.Builder.mergeSchemas((TupleMetadata)providedSchema, (TupleMetadata)tableSchema);
        negotiator.tableSchema(tupleSchema, true);
        this.loader = negotiator.build();
        this.taskToClose = new ScanTaskTableScanIterable(this.tableScan, this.work.getScanTask());
        this.records = this.taskToClose.iterator();
        IcebergColumnConverterFactory factory = new IcebergColumnConverterFactory(providedSchema);
        this.converter = factory.getRootConverter(providedSchema, (TupleMetadata)tableSchema, (TupleWriter)this.loader.writer());
        return true;
    }

    public boolean next() {
        RowSetLoader rowWriter = this.loader.writer();
        while (!rowWriter.isFull()) {
            if (this.nextLine(rowWriter)) continue;
            return false;
        }
        return true;
    }

    public void close() {
        AutoCloseables.closeSilently((AutoCloseable[])new AutoCloseable[]{this.taskToClose});
        this.loader.close();
    }

    private boolean nextLine(RowSetLoader rowWriter) {
        if (rowWriter.limitReached(this.maxRecords)) {
            return false;
        }
        if (!this.records.hasNext()) {
            return false;
        }
        rowWriter.start();
        this.converter.convert((Object)this.records.next());
        rowWriter.save();
        return true;
    }
}

