/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.UUID;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZKBasedMasterElectionUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZKBasedMasterElectionUtil.class);

    public static boolean acquireLock(ZKWatcher zooKeeperWatcher, String parentNode, String lockName) throws KeeperException, InterruptedException {
        LOGGER.info("Creating the parent lock node:" + parentNode);
        ZKUtil.createWithParents((ZKWatcher)zooKeeperWatcher, (String)parentNode);
        String lockNode = parentNode + "/" + lockName;
        String nodeValue = ZKBasedMasterElectionUtil.getHostName() + "_" + UUID.randomUUID().toString();
        LOGGER.info("Trying to acquire the lock by creating node:" + lockNode + " value:" + nodeValue);
        try {
            zooKeeperWatcher.getRecoverableZooKeeper().create(lockNode, Bytes.toBytes((String)nodeValue), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
        }
        catch (KeeperException.NodeExistsException e) {
            LOGGER.info("Could not acquire lock. Another process had already acquired the lock on Node " + lockName);
            return false;
        }
        LOGGER.info("Obtained the lock :" + lockNode);
        return true;
    }

    private static String getHostName() {
        String host = "";
        try {
            host = InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException e) {
            LOGGER.error("UnknownHostException while trying to get the Local Host address : ", (Throwable)e);
        }
        return host;
    }
}

