/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.transaction;

import java.io.IOException;
import java.sql.SQLException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixEmbeddedDriver;
import org.apache.phoenix.transaction.PhoenixTransactionClient;
import org.apache.phoenix.transaction.PhoenixTransactionContext;
import org.apache.phoenix.transaction.PhoenixTransactionService;
import org.apache.phoenix.transaction.TransactionFactory;

public interface PhoenixTransactionProvider {
    public PhoenixTransactionContext getTransactionContext(byte[] var1) throws IOException;

    public PhoenixTransactionContext getTransactionContext(PhoenixConnection var1) throws SQLException;

    public PhoenixTransactionClient getTransactionClient(Configuration var1, PhoenixEmbeddedDriver.ConnectionInfo var2) throws SQLException;

    public PhoenixTransactionService getTransactionService(Configuration var1, PhoenixEmbeddedDriver.ConnectionInfo var2, int var3) throws SQLException;

    public Class<? extends RegionObserver> getCoprocessor();

    public Class<? extends RegionObserver> getGCCoprocessor();

    public TransactionFactory.Provider getProvider();

    public boolean isUnsupported(Feature var1);

    public Put markPutAsCommitted(Put var1, long var2, long var4);

    public static enum Feature {
        ALTER_NONTX_TO_TX(SQLExceptionCode.CANNOT_ALTER_TABLE_FROM_NON_TXN_TO_TXNL),
        COLUMN_ENCODING(SQLExceptionCode.UNSUPPORTED_COLUMN_ENCODING_FOR_TXN_PROVIDER),
        MAINTAIN_LOCAL_INDEX_ON_SERVER(null),
        SET_TTL(SQLExceptionCode.TTL_UNSUPPORTED_FOR_TXN_TABLE),
        ALLOW_LOCAL_INDEX(SQLExceptionCode.CANNOT_CREATE_LOCAL_INDEX_FOR_TXN_TABLE);

        private final SQLExceptionCode code;

        private Feature(SQLExceptionCode code) {
            this.code = code;
        }

        public SQLExceptionCode getCode() {
            return this.code;
        }
    }
}

