/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.trace;

import java.io.IOException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.apache.htrace.Span;
import org.apache.htrace.SpanReceiver;
import org.apache.phoenix.query.QueryServicesOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TraceSpanReceiver
implements SpanReceiver {
    private static final Logger LOGGER = LoggerFactory.getLogger(TraceSpanReceiver.class);
    private static final int CAPACITY = QueryServicesOptions.withDefaults().getTracingTraceBufferSize();
    private BlockingQueue<Span> spanQueue = new ArrayBlockingQueue<Span>(CAPACITY);

    public void receiveSpan(Span span) {
        if (span.getTraceId() != 0L && this.spanQueue.offer(span)) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Span buffered to queue " + span.toJson());
            }
        } else if (span.getTraceId() != 0L && LOGGER.isDebugEnabled()) {
            LOGGER.debug("Span NOT buffered due to overflow in queue " + span.toJson());
        }
    }

    public void close() throws IOException {
    }

    boolean isSpanAvailable() {
        return this.spanQueue.isEmpty();
    }

    Span getSpan() {
        return (Span)this.spanQueue.poll();
    }

    int getNumSpans() {
        return this.spanQueue.size();
    }
}

