/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema.tuple;

import java.io.IOException;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.hbase.index.ValueGetter;
import org.apache.phoenix.hbase.index.covered.update.ColumnReference;
import org.apache.phoenix.schema.tuple.BaseTuple;

public class ValueGetterTuple
extends BaseTuple {
    private final ValueGetter valueGetter;
    private final long ts;

    public ValueGetterTuple(ValueGetter valueGetter, long ts) {
        this.valueGetter = valueGetter;
        this.ts = ts;
    }

    public ValueGetterTuple() {
        this.valueGetter = null;
        this.ts = Long.MAX_VALUE;
    }

    @Override
    public void getKey(ImmutableBytesWritable ptr) {
        ptr.set(this.valueGetter.getRowKey());
    }

    @Override
    public boolean isImmutable() {
        return true;
    }

    public KeyValue getValue(byte[] family, byte[] qualifier) {
        try {
            KeyValue kv = this.valueGetter.getLatestKeyValue(new ColumnReference(family, qualifier), this.ts);
            if (kv != null) {
                return kv;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        byte[] rowKey = this.valueGetter.getRowKey();
        byte[] valueBytes = HConstants.EMPTY_BYTE_ARRAY;
        return new KeyValue(rowKey, 0, rowKey.length, family, 0, family.length, qualifier, 0, qualifier.length, this.ts, KeyValue.Type.Put, valueBytes, 0, 0);
    }

    public String toString() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException();
    }

    public KeyValue getValue(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean getValue(byte[] family, byte[] qualifier, ImmutableBytesWritable ptr) {
        KeyValue kv = this.getValue(family, qualifier);
        if (kv == null) {
            return false;
        }
        ptr.set(kv.getValueArray(), kv.getValueOffset(), kv.getValueLength());
        return true;
    }
}

