/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema.stats;

import java.sql.Connection;
import org.antlr.runtime.CharStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.metrics.Gauge;
import org.apache.hadoop.hbase.metrics.impl.MetricRegistriesImpl;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobPriority;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.db.DBInputFormat;
import org.apache.hadoop.mapreduce.lib.output.NullOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.htrace.SpanReceiver;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.mapreduce.util.ConnectionUtil;
import org.apache.phoenix.mapreduce.util.PhoenixConfigurationUtil;
import org.apache.phoenix.mapreduce.util.PhoenixMapReduceUtil;
import org.apache.phoenix.thirdparty.org.apache.commons.cli.CommandLine;
import org.apache.phoenix.thirdparty.org.apache.commons.cli.DefaultParser;
import org.apache.phoenix.thirdparty.org.apache.commons.cli.HelpFormatter;
import org.apache.phoenix.thirdparty.org.apache.commons.cli.Option;
import org.apache.phoenix.thirdparty.org.apache.commons.cli.Options;
import org.apache.phoenix.thirdparty.org.apache.commons.cli.ParseException;
import org.apache.phoenix.util.SchemaUtil;
import org.joda.time.Chronology;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateStatisticsTool
extends Configured
implements Tool {
    private static final Logger LOGGER = LoggerFactory.getLogger(UpdateStatisticsTool.class);
    private static final Option TABLE_NAME_OPTION = new Option("t", "table", true, "Phoenix Table Name");
    private static final Option SNAPSHOT_NAME_OPTION = new Option("s", "snapshot", true, "HBase Snapshot Name");
    private static final Option RESTORE_DIR_OPTION = new Option("d", "restore-dir", true, "Restore Directory for HBase snapshot");
    private static final Option JOB_PRIORITY_OPTION = new Option("p", "job-priority", true, "Define job priority from 0(highest) to 4");
    private static final Option RUN_FOREGROUND_OPTION = new Option("runfg", "run-foreground", false, "If specified, runs UpdateStatisticsTool in Foreground. Default - Runs the build in background");
    private static final Option MANAGE_SNAPSHOT_OPTION = new Option("ms", "manage-snapshot", false, "Creates a new snapshot, runs the tool and deletes it");
    private static final Option HELP_OPTION = new Option("h", "help", false, "Help");
    private String tableName;
    private String snapshotName;
    private Path restoreDir;
    private JobPriority jobPriority;
    private boolean manageSnapshot;
    private boolean isForeground;
    private Job job;

    public int run(String[] args) throws Exception {
        this.parseArgs(args);
        this.preJobTask();
        this.configureJob();
        TableMapReduceUtil.initCredentials((Job)this.job);
        int ret = this.runJob();
        this.postJobTask();
        return ret;
    }

    private void preJobTask() throws Exception {
        if (!this.manageSnapshot) {
            return;
        }
        try (Connection conn = ConnectionUtil.getInputConnection(this.getConf());){
            Admin admin = conn.unwrap(PhoenixConnection.class).getQueryServices().getAdmin();
            boolean namespaceMapping = this.getConf().getBoolean("phoenix.schema.isNamespaceMappingEnabled", false);
            String physicalTableName = SchemaUtil.getPhysicalTableName(this.tableName.getBytes(), namespaceMapping).getNameAsString();
            admin.snapshot(this.snapshotName, TableName.valueOf((String)physicalTableName));
            LOGGER.info("Successfully created snapshot " + this.snapshotName + " for " + physicalTableName);
        }
    }

    private void postJobTask() throws Exception {
        if (!this.manageSnapshot) {
            return;
        }
        try (Connection conn = ConnectionUtil.getInputConnection(this.getConf());){
            Admin admin = conn.unwrap(PhoenixConnection.class).getQueryServices().getAdmin();
            admin.deleteSnapshot(this.snapshotName);
            LOGGER.info("Successfully deleted snapshot " + this.snapshotName);
        }
    }

    void parseArgs(String[] args) {
        String restoreDirOptionValue;
        CommandLine cmdLine = null;
        try {
            cmdLine = this.parseOptions(args);
        }
        catch (IllegalStateException e) {
            this.printHelpAndExit(e.getMessage(), this.getOptions());
        }
        if (this.getConf() == null) {
            this.setConf(HBaseConfiguration.create());
        }
        this.tableName = cmdLine.getOptionValue(TABLE_NAME_OPTION.getOpt());
        this.snapshotName = cmdLine.getOptionValue(SNAPSHOT_NAME_OPTION.getOpt());
        if (this.snapshotName == null) {
            this.snapshotName = "UpdateStatisticsTool_" + this.tableName + "_" + System.currentTimeMillis();
        }
        if ((restoreDirOptionValue = cmdLine.getOptionValue(RESTORE_DIR_OPTION.getOpt())) == null) {
            restoreDirOptionValue = this.getConf().get("fs.defaultFS") + "/tmp";
        }
        this.jobPriority = this.getJobPriority(cmdLine);
        this.restoreDir = new Path(restoreDirOptionValue);
        this.manageSnapshot = cmdLine.hasOption(MANAGE_SNAPSHOT_OPTION.getOpt());
        this.isForeground = cmdLine.hasOption(RUN_FOREGROUND_OPTION.getOpt());
    }

    public String getJobPriority() {
        return this.jobPriority.toString();
    }

    private JobPriority getJobPriority(CommandLine cmdLine) {
        String jobPriorityOption = cmdLine.getOptionValue(JOB_PRIORITY_OPTION.getOpt());
        if (jobPriorityOption == null) {
            return JobPriority.NORMAL;
        }
        switch (jobPriorityOption) {
            case "0": {
                return JobPriority.VERY_HIGH;
            }
            case "1": {
                return JobPriority.HIGH;
            }
            case "2": {
                return JobPriority.NORMAL;
            }
            case "3": {
                return JobPriority.LOW;
            }
            case "4": {
                return JobPriority.VERY_LOW;
            }
        }
        return JobPriority.NORMAL;
    }

    private void configureJob() throws Exception {
        this.job = Job.getInstance((Configuration)this.getConf(), (String)("UpdateStatistics-" + this.tableName + "-" + this.snapshotName));
        PhoenixMapReduceUtil.setInput(this.job, DBInputFormat.NullDBWritable.class, this.snapshotName, this.tableName, this.restoreDir);
        PhoenixConfigurationUtil.setMRJobType(this.job.getConfiguration(), PhoenixConfigurationUtil.MRJobType.UPDATE_STATS);
        PhoenixConfigurationUtil.setSplitByStats(this.job.getConfiguration(), false);
        this.job.setJarByClass(UpdateStatisticsTool.class);
        this.job.setMapperClass(TableSnapshotMapper.class);
        this.job.setMapOutputKeyClass(NullWritable.class);
        this.job.setMapOutputValueClass(NullWritable.class);
        this.job.setOutputFormatClass(NullOutputFormat.class);
        this.job.setNumReduceTasks(0);
        this.job.setPriority(this.jobPriority);
        TableMapReduceUtil.addDependencyJars((Job)this.job);
        TableMapReduceUtil.addDependencyJarsForClasses((Configuration)this.job.getConfiguration(), (Class[])new Class[]{PhoenixConnection.class, Chronology.class, CharStream.class, SpanReceiver.class, Gauge.class, MetricRegistriesImpl.class});
        try {
            TableMapReduceUtil.addDependencyJarsForClasses((Configuration)this.job.getConfiguration(), (Class[])new Class[]{Class.forName("org.apache.tephra.TransactionNotInProgressException"), Class.forName("org.apache.tephra.TransactionSystemClient"), Class.forName("org.apache.tephra.hbase.coprocessor.TransactionProcessor"), Class.forName("org.apache.thrift.transport.TTransportException")});
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        LOGGER.info("UpdateStatisticsTool running for: " + this.tableName + " on snapshot: " + this.snapshotName + " with restore dir: " + this.restoreDir);
    }

    private int runJob() {
        try {
            if (this.isForeground) {
                LOGGER.info("Running UpdateStatisticsTool in Foreground. Runs full table scans. This may take a long time!");
                return this.job.waitForCompletion(true) ? 0 : 1;
            }
            LOGGER.info("Running UpdateStatisticsTool in Background - Submit async and exit");
            this.job.submit();
            return 0;
        }
        catch (Exception e) {
            LOGGER.error("Caught exception " + e + " trying to update statistics.");
            return 1;
        }
    }

    private void printHelpAndExit(String errorMessage, Options options) {
        System.err.println(errorMessage);
        this.printHelpAndExit(options, 1);
    }

    private void printHelpAndExit(Options options, int exitCode) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("help", options);
        System.exit(exitCode);
    }

    CommandLine parseOptions(String[] args) {
        Options options = this.getOptions();
        DefaultParser parser = new DefaultParser(false, false);
        CommandLine cmdLine = null;
        try {
            cmdLine = parser.parse(options, args);
        }
        catch (ParseException e) {
            this.printHelpAndExit("Error parsing command line options: " + e.getMessage(), options);
        }
        if (cmdLine.hasOption(HELP_OPTION.getOpt())) {
            this.printHelpAndExit(options, 0);
        }
        if (!cmdLine.hasOption(TABLE_NAME_OPTION.getOpt())) {
            throw new IllegalStateException(TABLE_NAME_OPTION.getLongOpt() + " is a mandatory parameter");
        }
        if (cmdLine.hasOption(MANAGE_SNAPSHOT_OPTION.getOpt()) && !cmdLine.hasOption(RUN_FOREGROUND_OPTION.getOpt())) {
            throw new IllegalStateException("Snapshot cannot be managed if job is running in background");
        }
        return cmdLine;
    }

    private Options getOptions() {
        Options options = new Options();
        options.addOption(TABLE_NAME_OPTION);
        options.addOption(SNAPSHOT_NAME_OPTION);
        options.addOption(HELP_OPTION);
        options.addOption(RESTORE_DIR_OPTION);
        options.addOption(JOB_PRIORITY_OPTION);
        options.addOption(RUN_FOREGROUND_OPTION);
        options.addOption(MANAGE_SNAPSHOT_OPTION);
        return options;
    }

    public Job getJob() {
        return this.job;
    }

    public String getSnapshotName() {
        return this.snapshotName;
    }

    public Path getRestoreDir() {
        return this.restoreDir;
    }

    public static void main(String[] args) throws Exception {
        int result = ToolRunner.run((Tool)new UpdateStatisticsTool(), (String[])args);
        System.exit(result);
    }

    public static class TableSnapshotMapper
    extends Mapper<NullWritable, DBInputFormat.NullDBWritable, NullWritable, NullWritable> {
        protected void map(NullWritable key, DBInputFormat.NullDBWritable value, Mapper.Context context) {
        }
    }
}

