/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.mapreduce.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.thirdparty.com.google.common.base.Function;
import org.apache.phoenix.thirdparty.com.google.common.collect.Iterables;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.util.IndexUtil;
import org.apache.phoenix.util.SchemaUtil;

public class IndexColumnNames {
    private List<String> dataNonPkColNames = Lists.newArrayList();
    private List<String> dataPkColNames = Lists.newArrayList();
    private List<String> dataColNames;
    protected List<String> dataColSqlTypeNames = Lists.newArrayList();
    private List<String> indexPkColNames = Lists.newArrayList();
    private List<String> indexNonPkColNames = Lists.newArrayList();
    private List<String> indexColNames;
    protected List<String> indexColSqlTypeNames = Lists.newArrayList();
    private PTable pdataTable;
    private PTable pindexTable;

    public IndexColumnNames(PTable pdataTable, PTable pindexTable) {
        PColumn dCol;
        String indexColName;
        this.pdataTable = pdataTable;
        this.pindexTable = pindexTable;
        List<PColumn> pindexCols = pindexTable.getColumns();
        List<PColumn> pkColumns = pindexTable.getPKColumns();
        HashSet<String> indexColsAdded = new HashSet<String>();
        int offset = 0;
        if (pindexTable.getBucketNum() != null) {
            ++offset;
        }
        if (pindexTable.getViewIndexId() != null) {
            ++offset;
        }
        if (pindexTable.isMultiTenant() && pindexTable.getViewIndexId() != null) {
            ++offset;
        }
        if (offset > 0) {
            pindexCols = pindexCols.subList(offset, pindexCols.size());
            pkColumns = pkColumns.subList(offset, pkColumns.size());
        }
        for (PColumn indexCol : pindexCols) {
            if (!IndexUtil.isDataPKColumn(indexCol)) continue;
            String indexColumnName = indexCol.getName().getString();
            PColumn dPkCol = IndexUtil.getDataColumn(pdataTable, indexColumnName);
            this.dataPkColNames.add(this.getDataColFullName(dPkCol));
            this.dataColSqlTypeNames.add(this.getDataTypeString(dPkCol));
            this.indexPkColNames.add(indexColumnName);
            this.indexColSqlTypeNames.add(this.getDataTypeString(indexCol));
            indexColsAdded.add(indexColumnName);
        }
        for (PColumn indexPkCol : pkColumns) {
            indexColName = indexPkCol.getName().getString();
            if (indexColsAdded.contains(indexColName)) continue;
            this.indexPkColNames.add(indexColName);
            this.indexColSqlTypeNames.add(this.getDataTypeString(indexPkCol));
            dCol = IndexUtil.getDataColumn(pdataTable, indexColName);
            this.dataNonPkColNames.add(this.getDataColFullName(dCol));
            this.dataColSqlTypeNames.add(this.getDataTypeString(dCol));
            indexColsAdded.add(indexColName);
        }
        for (PColumn indexCol : pindexCols) {
            indexColName = indexCol.getName().getString();
            if (indexColsAdded.contains(indexColName)) continue;
            this.indexNonPkColNames.add(indexColName);
            this.indexColSqlTypeNames.add(this.getDataTypeString(indexCol));
            dCol = IndexUtil.getDataColumn(pdataTable, indexColName);
            this.dataNonPkColNames.add(this.getDataColFullName(dCol));
            this.dataColSqlTypeNames.add(this.getDataTypeString(dCol));
        }
        this.indexColNames = Lists.newArrayList((Iterable)Iterables.concat(this.indexPkColNames, this.indexNonPkColNames));
        this.dataColNames = Lists.newArrayList((Iterable)Iterables.concat(this.dataPkColNames, this.dataNonPkColNames));
    }

    private String getDataTypeString(PColumn col) {
        PDataType dataType = col.getDataType();
        switch (dataType.getSqlType()) {
            case 3: {
                String typeStr = dataType.toString();
                if (col.getMaxLength() != null) {
                    typeStr = typeStr + "(" + col.getMaxLength().toString();
                    if (col.getScale() != null) {
                        typeStr = typeStr + "," + col.getScale().toString();
                    }
                    typeStr = typeStr + ")";
                }
                return typeStr;
            }
        }
        if (col.getMaxLength() != null) {
            return String.format("%s(%s)", dataType.toString(), col.getMaxLength());
        }
        return dataType.toString();
    }

    private String getDataColFullName(PColumn dCol) {
        String dColFullName = "";
        if (dCol.getFamilyName() != null) {
            dColFullName = dColFullName + dCol.getFamilyName().getString() + ".";
        }
        dColFullName = dColFullName + dCol.getName().getString();
        return dColFullName;
    }

    private List<String> getDynamicCols(List<String> colNames, List<String> colTypes) {
        ArrayList dynamicCols = Lists.newArrayListWithCapacity((int)colNames.size());
        for (int i = 0; i < colNames.size(); ++i) {
            String dataColName = colNames.get(i);
            String dataColType = colTypes.get(i);
            String dynamicCol = SchemaUtil.getEscapedFullColumnName(dataColName) + " " + dataColType;
            dynamicCols.add(dynamicCol);
        }
        return dynamicCols;
    }

    private List<String> getUnqualifiedColNames(List<String> qualifiedCols) {
        return Lists.transform(qualifiedCols, (Function)new Function<String, String>(){

            public String apply(String qCol) {
                return SchemaUtil.getTableNameFromFullName(qCol, ".");
            }
        });
    }

    protected List<String> getCastedColumnNames(List<String> colNames, List<String> castTypes) {
        ArrayList castColNames = Lists.newArrayListWithCapacity((int)colNames.size());
        colNames = SchemaUtil.getEscapedFullColumnNames(colNames);
        for (int i = 0; i < colNames.size(); ++i) {
            castColNames.add("CAST(" + colNames.get(i) + " AS " + castTypes.get(i) + ")");
        }
        return castColNames;
    }

    public String getQualifiedDataTableName() {
        return SchemaUtil.getQualifiedTableName(this.pdataTable.getSchemaName().getString(), this.pdataTable.getTableName().getString());
    }

    public String getQualifiedIndexTableName() {
        return SchemaUtil.getQualifiedTableName(this.pindexTable.getSchemaName().getString(), this.pindexTable.getTableName().getString());
    }

    public List<String> getDynamicDataCols() {
        return this.getDynamicCols(this.getUnqualifiedDataColNames(), this.dataColSqlTypeNames);
    }

    public List<String> getDynamicIndexCols() {
        return this.getDynamicCols(this.getUnqualifiedIndexColNames(), this.indexColSqlTypeNames);
    }

    public List<String> getDataColNames() {
        return this.dataColNames;
    }

    public List<String> getUnqualifiedDataColNames() {
        return this.getUnqualifiedColNames(this.dataColNames);
    }

    public List<String> getDataNonPkColNames() {
        return this.dataNonPkColNames;
    }

    public List<String> getDataPkColNames() {
        return this.dataPkColNames;
    }

    public List<String> getIndexColNames() {
        return this.indexColNames;
    }

    public List<String> getUnqualifiedIndexColNames() {
        return this.getUnqualifiedColNames(this.indexColNames);
    }

    public List<String> getIndexPkColNames() {
        return this.indexPkColNames;
    }
}

