/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.iterate;

import java.sql.SQLException;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.iterate.MaterializedComparableResultIterator;
import org.apache.phoenix.iterate.PeekingResultIterator;
import org.apache.phoenix.iterate.ResultIterators;
import org.apache.phoenix.schema.tuple.Tuple;

public abstract class MergeSortResultIterator
implements PeekingResultIterator {
    protected final ResultIterators resultIterators;
    protected final ImmutableBytesWritable tempPtr = new ImmutableBytesWritable();
    private PriorityQueue<MaterializedComparableResultIterator> minHeap;
    private final IteratorComparator itrComparator = new IteratorComparator();

    public MergeSortResultIterator(ResultIterators iterators) {
        this.resultIterators = iterators;
    }

    @Override
    public void close() throws SQLException {
        this.resultIterators.close();
    }

    protected abstract int compare(Tuple var1, Tuple var2);

    @Override
    public Tuple peek() throws SQLException {
        MaterializedComparableResultIterator iterator = this.minIterator();
        if (iterator == null) {
            return null;
        }
        return iterator.peek();
    }

    @Override
    public Tuple next() throws SQLException {
        MaterializedComparableResultIterator iterator = this.minIterator();
        if (iterator == null) {
            return null;
        }
        Tuple next = iterator.next();
        this.minHeap.poll();
        if (iterator.peek() != null) {
            this.minHeap.add(iterator);
        } else {
            iterator.close();
        }
        return next;
    }

    private PriorityQueue<MaterializedComparableResultIterator> getMinHeap() throws SQLException {
        if (this.minHeap == null) {
            List<PeekingResultIterator> iterators = this.resultIterators.getIterators();
            this.minHeap = new PriorityQueue(Math.max(1, iterators.size()));
            for (PeekingResultIterator itr : iterators) {
                if (itr.peek() == null) {
                    itr.close();
                    continue;
                }
                this.minHeap.add(new MaterializedComparableResultIterator(itr, this.itrComparator));
            }
        }
        return this.minHeap;
    }

    private MaterializedComparableResultIterator minIterator() throws SQLException {
        PriorityQueue<MaterializedComparableResultIterator> minHeap = this.getMinHeap();
        MaterializedComparableResultIterator minIterator = minHeap.peek();
        return minIterator;
    }

    private class IteratorComparator
    implements Comparator<Tuple> {
        private IteratorComparator() {
        }

        @Override
        public int compare(Tuple c1, Tuple c2) {
            return MergeSortResultIterator.this.compare(c1, c2);
        }
    }
}

