/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.function;

import java.io.DataInput;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.expression.function.ScalarFunction;
import org.apache.phoenix.parse.FunctionParseNode;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.schema.types.PVarchar;

@FunctionParseNode.BuiltInFunction(name="INSTR", args={@FunctionParseNode.Argument(allowedTypes={PVarchar.class}), @FunctionParseNode.Argument(allowedTypes={PVarchar.class})})
public class InstrFunction
extends ScalarFunction {
    public static final String NAME = "INSTR";
    private String literalSourceStr = null;
    private String literalSearchStr = null;

    public InstrFunction() {
    }

    public InstrFunction(List<Expression> children) {
        super(children);
        this.init();
    }

    private void init() {
        this.literalSourceStr = this.maybeExtractLiteralString(this.getChildren().get(0));
        this.literalSearchStr = this.maybeExtractLiteralString(this.getChildren().get(1));
    }

    private String maybeExtractLiteralString(Expression expr) {
        if (expr instanceof LiteralExpression) {
            return (String)((LiteralExpression)expr).getValue();
        }
        return null;
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        String searchStr;
        String sourceStr = this.literalSourceStr;
        if (sourceStr == null) {
            Expression child = this.getChildren().get(0);
            if (!child.evaluate(tuple, ptr)) {
                return false;
            }
            if (ptr.getLength() == 0) {
                return true;
            }
            sourceStr = (String)PVarchar.INSTANCE.toObject(ptr, child.getSortOrder());
        }
        if ((searchStr = this.literalSearchStr) == null) {
            Expression child = this.getChildren().get(1);
            if (!child.evaluate(tuple, ptr)) {
                return false;
            }
            if (ptr.getLength() == 0) {
                return true;
            }
            searchStr = (String)PVarchar.INSTANCE.toObject(ptr, child.getSortOrder());
        }
        int position = sourceStr.indexOf(searchStr) + 1;
        ptr.set(PInteger.INSTANCE.toBytes(position));
        return true;
    }

    @Override
    public PDataType getDataType() {
        return PInteger.INSTANCE;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void readFields(DataInput input) throws IOException {
        super.readFields(input);
        this.init();
    }
}

