/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.function;

import java.sql.Date;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.CoerceExpression;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.expression.function.FloorMonthExpression;
import org.apache.phoenix.expression.function.FloorWeekExpression;
import org.apache.phoenix.expression.function.FloorYearExpression;
import org.apache.phoenix.expression.function.RoundDateExpression;
import org.apache.phoenix.expression.function.TimeUnit;
import org.apache.phoenix.parse.FunctionParseNode;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PDate;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.schema.types.PTimestamp;
import org.apache.phoenix.schema.types.PUnsignedDate;
import org.apache.phoenix.schema.types.PUnsignedTimestamp;
import org.apache.phoenix.schema.types.PVarchar;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;

@FunctionParseNode.BuiltInFunction(name="FLOOR", args={@FunctionParseNode.Argument(allowedTypes={PTimestamp.class}), @FunctionParseNode.Argument(allowedTypes={PVarchar.class, PInteger.class}, defaultValue="null", isConstant=true), @FunctionParseNode.Argument(allowedTypes={PInteger.class}, defaultValue="1", isConstant=true)}, classType=FunctionParseNode.FunctionClassType.DERIVED)
public class FloorDateExpression
extends RoundDateExpression {
    public FloorDateExpression() {
    }

    public FloorDateExpression(List<Expression> children) {
        super(children);
    }

    public static Expression create(List<Expression> children) throws SQLException {
        Object timeUnitValue;
        Expression firstChild = children.get(0);
        PDataType firstChildDataType = firstChild.getDataType();
        if (firstChildDataType == PTimestamp.INSTANCE || firstChildDataType == PUnsignedTimestamp.INSTANCE) {
            ArrayList newChildren = Lists.newArrayListWithExpectedSize((int)children.size());
            newChildren.add(CoerceExpression.create(firstChild, firstChildDataType == PTimestamp.INSTANCE ? PDate.INSTANCE : PUnsignedDate.INSTANCE));
            newChildren.addAll(children.subList(1, children.size()));
            children = newChildren;
        }
        TimeUnit timeUnit = TimeUnit.getTimeUnit((timeUnitValue = ((LiteralExpression)children.get(1)).getValue()) != null ? timeUnitValue.toString() : null);
        switch (timeUnit) {
            case WEEK: {
                return new FloorWeekExpression(children);
            }
            case MONTH: {
                return new FloorMonthExpression(children);
            }
            case YEAR: {
                return new FloorYearExpression(children);
            }
        }
        return new FloorDateExpression(children);
    }

    public static Expression create(Expression expr, TimeUnit timeUnit) throws SQLException {
        return FloorDateExpression.create(expr, timeUnit, 1);
    }

    public static Expression create(Expression expr, TimeUnit timeUnit, int multiplier) throws SQLException {
        Expression timeUnitExpr = FloorDateExpression.getTimeUnitExpr(timeUnit);
        Expression defaultMultiplierExpr = FloorDateExpression.getMultiplierExpr(multiplier);
        ArrayList expressions = Lists.newArrayList((Object[])new Expression[]{expr, timeUnitExpr, defaultMultiplierExpr});
        return FloorDateExpression.create(expressions);
    }

    @Override
    protected long getRoundUpAmount() {
        return 0L;
    }

    @Override
    public String getName() {
        return "FLOOR";
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        if (((Expression)this.children.get(0)).evaluate(tuple, ptr)) {
            if (ptr.getLength() == 0) {
                return true;
            }
            PDataType dataType = this.getDataType();
            long time = dataType.getCodec().decodeLong(ptr, ((Expression)this.children.get(0)).getSortOrder());
            long value = this.roundTime(time);
            Date d = new Date(value);
            byte[] byteValue = dataType.toBytes(d);
            ptr.set(byteValue);
            return true;
        }
        return false;
    }
}

