/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression;

import java.io.DataOutput;
import java.io.IOException;
import java.sql.SQLException;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.execute.RuntimeContext;
import org.apache.phoenix.expression.BaseTerminalExpression;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.expression.visitor.ExpressionVisitor;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PDataType;

public class CorrelateVariableFieldAccessExpression
extends BaseTerminalExpression {
    private final RuntimeContext runtimeContext;
    private final String variableId;
    private final Expression fieldAccessExpression;

    public CorrelateVariableFieldAccessExpression(RuntimeContext context, String variableId, Expression fieldAccessExpression) {
        this.runtimeContext = context;
        this.variableId = variableId;
        this.fieldAccessExpression = fieldAccessExpression;
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        Tuple variable = this.runtimeContext.getCorrelateVariableValue(this.variableId);
        if (variable == null) {
            throw new RuntimeException("Variable '" + this.variableId + "' not set.");
        }
        return this.fieldAccessExpression.evaluate(variable, ptr);
    }

    @Override
    public <T> T accept(ExpressionVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public void write(DataOutput output) throws IOException {
        ImmutableBytesWritable ptr = new ImmutableBytesWritable();
        boolean success = this.evaluate(null, ptr);
        Object value = success ? this.getDataType().toObject(ptr) : null;
        try {
            LiteralExpression expr = LiteralExpression.newConstant(value, this.getDataType());
            expr.write(output);
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    @Override
    public PDataType getDataType() {
        return this.fieldAccessExpression.getDataType();
    }
}

