/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.execute;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.cache.IndexMetaDataCache;
import org.apache.phoenix.compile.ScanRanges;
import org.apache.phoenix.coprocessor.MetaDataProtocol;
import org.apache.phoenix.filter.SkipScanFilter;
import org.apache.phoenix.hbase.index.AbstractValueGetter;
import org.apache.phoenix.hbase.index.MultiMutation;
import org.apache.phoenix.hbase.index.ValueGetter;
import org.apache.phoenix.hbase.index.covered.IndexMetaData;
import org.apache.phoenix.hbase.index.covered.IndexUpdate;
import org.apache.phoenix.hbase.index.covered.TableState;
import org.apache.phoenix.hbase.index.covered.update.ColumnReference;
import org.apache.phoenix.hbase.index.covered.update.ColumnTracker;
import org.apache.phoenix.hbase.index.covered.update.IndexedColumnGroup;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.index.IndexMaintainer;
import org.apache.phoenix.index.PhoenixIndexCodec;
import org.apache.phoenix.index.PhoenixIndexMetaData;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.query.ConnectionQueryServices;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.types.PVarbinary;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.thirdparty.com.google.common.collect.Sets;
import org.apache.phoenix.thirdparty.com.google.common.primitives.Longs;
import org.apache.phoenix.transaction.PhoenixTransactionContext;
import org.apache.phoenix.util.PhoenixKeyValueUtil;
import org.apache.phoenix.util.ScanUtil;
import org.apache.phoenix.util.SchemaUtil;

public class PhoenixTxIndexMutationGenerator {
    private final PhoenixIndexCodec codec;
    private final PhoenixIndexMetaData indexMetaData;
    private final ConnectionQueryServices services;
    private final byte[] regionStartKey;
    private final byte[] regionEndKey;
    private final byte[] tableName;

    private PhoenixTxIndexMutationGenerator(ConnectionQueryServices services, Configuration conf, PhoenixIndexMetaData indexMetaData, byte[] tableName, byte[] regionStartKey, byte[] regionEndKey) {
        this.services = services;
        this.indexMetaData = indexMetaData;
        this.regionStartKey = regionStartKey;
        this.regionEndKey = regionEndKey;
        this.tableName = tableName;
        this.codec = new PhoenixIndexCodec(conf, tableName);
    }

    public PhoenixTxIndexMutationGenerator(Configuration conf, PhoenixIndexMetaData indexMetaData, byte[] tableName, byte[] regionStartKey, byte[] regionEndKey) {
        this(null, conf, indexMetaData, tableName, regionStartKey, regionEndKey);
    }

    public PhoenixTxIndexMutationGenerator(ConnectionQueryServices services, PhoenixIndexMetaData indexMetaData, byte[] tableName) {
        this(services, services.getConfiguration(), indexMetaData, tableName, null, null);
    }

    private static void addMutation(Map<ImmutableBytesPtr, MultiMutation> mutations, ImmutableBytesPtr row, Mutation m) {
        MultiMutation stored = mutations.get((Object)row);
        if (stored == null) {
            stored = new MultiMutation(row);
            mutations.put(row, stored);
        }
        stored.addAll(m);
    }

    public Collection<Pair<Mutation, byte[]>> getIndexUpdates(Table htable, Iterator<? extends Mutation> mutationIterator) throws IOException, SQLException {
        if (!mutationIterator.hasNext()) {
            return Collections.emptyList();
        }
        List<IndexMaintainer> indexMaintainers = this.indexMetaData.getIndexMaintainers();
        ResultScanner currentScanner = null;
        HashMap<ImmutableBytesPtr, MultiMutation> mutations = new HashMap<ImmutableBytesPtr, MultiMutation>();
        int estimatedSize = indexMaintainers.size() * 10;
        HashSet mutableColumns = Sets.newHashSetWithExpectedSize((int)estimatedSize);
        for (IndexMaintainer indexMaintainer : indexMaintainers) {
            Set<ColumnReference> allColumns = indexMaintainer.getAllColumns();
            mutableColumns.addAll(allColumns);
        }
        Mutation m = mutationIterator.next();
        Map updateAttributes = m.getAttributesMap();
        byte[] txRollbackAttribute = (byte[])updateAttributes.get("tephra.tx.rollback");
        boolean isRollback = txRollbackAttribute != null;
        boolean isImmutable = this.indexMetaData.isImmutableRows();
        HashMap<ImmutableBytesPtr, MultiMutation> findPriorValueMutations = isImmutable && !isRollback ? new HashMap() : mutations;
        while (true) {
            ImmutableBytesPtr row = new ImmutableBytesPtr(m.getRow());
            if (mutations != findPriorValueMutations && this.indexMetaData.requiresPriorRowState(m)) {
                PhoenixTxIndexMutationGenerator.addMutation(findPriorValueMutations, row, m);
            }
            PhoenixTxIndexMutationGenerator.addMutation(mutations, row, m);
            if (!mutationIterator.hasNext()) break;
            m = mutationIterator.next();
        }
        ArrayList<Pair<Mutation, byte[]>> indexUpdates = new ArrayList<Pair<Mutation, byte[]>>(mutations.size() * 2 * indexMaintainers.size());
        if (!findPriorValueMutations.isEmpty()) {
            ArrayList keys = Lists.newArrayListWithExpectedSize((int)mutations.size());
            for (Object ptr : findPriorValueMutations.keySet()) {
                keys.add(PVarbinary.INSTANCE.getKeyRange(((ImmutableBytesPtr)((Object)ptr)).copyBytesIfNecessary()));
            }
            Scan scan = new Scan();
            for (ColumnReference ref : mutableColumns) {
                scan.addColumn(ref.getFamily(), ref.getQualifier());
            }
            byte[] emptyKeyValueQualifier = indexMaintainers.get(0).getEmptyKeyValueQualifier();
            scan.addColumn(indexMaintainers.get(0).getDataEmptyKeyValueCF(), emptyKeyValueQualifier);
            ScanRanges scanRanges = ScanRanges.create(SchemaUtil.VAR_BINARY_SCHEMA, Collections.singletonList(keys), ScanUtil.SINGLE_COLUMN_SLOT_SPAN, null, true, -1);
            scanRanges.initializeScan(scan);
            Table txTable = this.indexMetaData.getTransactionContext().getTransactionalTable(htable, true);
            SkipScanFilter filter = scanRanges.getSkipScanFilter();
            if (isRollback) {
                filter = new SkipScanFilter(filter, true);
                this.indexMetaData.getTransactionContext().setVisibilityLevel(PhoenixTransactionContext.PhoenixVisibilityLevel.SNAPSHOT_ALL);
            }
            scan.setFilter((Filter)filter);
            currentScanner = txTable.getScanner(scan);
        }
        if (isRollback) {
            this.processRollback(this.indexMetaData, txRollbackAttribute, currentScanner, mutableColumns, indexUpdates, mutations);
        } else {
            this.processMutation(this.indexMetaData, txRollbackAttribute, currentScanner, mutableColumns, indexUpdates, mutations, findPriorValueMutations);
        }
        return indexUpdates;
    }

    private void processMutation(PhoenixIndexMetaData indexMetaData, byte[] txRollbackAttribute, ResultScanner scanner, Set<ColumnReference> upsertColumns, Collection<Pair<Mutation, byte[]>> indexUpdates, Map<ImmutableBytesPtr, MultiMutation> mutations, Map<ImmutableBytesPtr, MultiMutation> mutationsToFindPreviousValue) throws IOException {
        List<IndexMaintainer> indexMaintainers = indexMetaData.getIndexMaintainers();
        if (scanner != null) {
            Result result;
            ColumnReference columnReference = new ColumnReference(indexMaintainers.get(0).getDataEmptyKeyValueCF(), indexMaintainers.get(0).getEmptyKeyValueQualifier());
            while ((result = scanner.next()) != null) {
                Mutation m = mutationsToFindPreviousValue.remove((Object)new ImmutableBytesPtr(result.getRow()));
                TxTableState state2 = new TxTableState(upsertColumns, indexMetaData.getTransactionContext().getWritePointer(), m, columnReference, result);
                this.generateDeletes(indexMetaData, indexUpdates, txRollbackAttribute, state2);
                this.generatePuts(indexMetaData, indexUpdates, state2);
            }
        }
        for (Mutation mutation : mutations.values()) {
            TxTableState state3 = new TxTableState(upsertColumns, indexMetaData.getTransactionContext().getWritePointer(), mutation);
            this.generatePuts(indexMetaData, indexUpdates, state3);
            this.generateDeletes(indexMetaData, indexUpdates, txRollbackAttribute, state3);
        }
    }

    private void processRollback(PhoenixIndexMetaData indexMetaData, byte[] txRollbackAttribute, ResultScanner scanner, Set<ColumnReference> mutableColumns, Collection<Pair<Mutation, byte[]>> indexUpdates, Map<ImmutableBytesPtr, MultiMutation> mutations) throws IOException {
        if (scanner != null) {
            Result result;
            long readPtr = indexMetaData.getTransactionContext().getReadPointer();
            ColumnReference emptyColRef = new ColumnReference(indexMetaData.getIndexMaintainers().get(0).getDataEmptyKeyValueCF(), indexMetaData.getIndexMaintainers().get(0).getEmptyKeyValueQualifier());
            while ((result = scanner.next()) != null) {
                Mutation m = mutations.remove((Object)new ImmutableBytesPtr(result.getRow()));
                List cells = result.listCells();
                Collections.sort(cells, new Comparator<Cell>(){

                    @Override
                    public int compare(Cell o1, Cell o2) {
                        int c = Longs.compare((long)o1.getTimestamp(), (long)o2.getTimestamp());
                        if (c != 0) {
                            return c;
                        }
                        c = o1.getTypeByte() - o2.getTypeByte();
                        if (c != 0) {
                            return c;
                        }
                        c = Bytes.compareTo((byte[])o1.getFamilyArray(), (int)o1.getFamilyOffset(), (int)o1.getFamilyLength(), (byte[])o1.getFamilyArray(), (int)o1.getFamilyOffset(), (int)o1.getFamilyLength());
                        if (c != 0) {
                            return c;
                        }
                        return Bytes.compareTo((byte[])o1.getQualifierArray(), (int)o1.getQualifierOffset(), (int)o1.getQualifierLength(), (byte[])o1.getQualifierArray(), (int)o1.getQualifierOffset(), (int)o1.getQualifierLength());
                    }
                });
                int i = 0;
                int nCells = cells.size();
                Result oldResult = null;
                do {
                    TxTableState state2;
                    long writePtr;
                    boolean hasPuts = false;
                    LinkedList singleTimeCells = Lists.newLinkedList();
                    Cell cell = (Cell)cells.get(i);
                    do {
                        hasPuts |= cell.getTypeByte() == KeyValue.Type.Put.getCode();
                        writePtr = cell.getTimestamp();
                        ListIterator<Cell> it = singleTimeCells.listIterator();
                        do {
                            it.add(cell);
                        } while (++i < nCells && (cell = (Cell)cells.get(i)).getTimestamp() == writePtr);
                    } while (i < nCells && cell.getTimestamp() <= readPtr);
                    if (oldResult != null) {
                        state2 = new TxTableState(mutableColumns, writePtr, m, emptyColRef, oldResult);
                        this.generateDeletes(indexMetaData, indexUpdates, txRollbackAttribute, state2);
                    }
                    if (hasPuts) {
                        Result newResult = Result.create((List)singleTimeCells);
                        if (writePtr > readPtr) {
                            state2 = new TxTableState(mutableColumns, writePtr, m, emptyColRef, newResult);
                            this.generateDeletes(indexMetaData, indexUpdates, txRollbackAttribute, state2);
                        }
                        oldResult = newResult;
                        continue;
                    }
                    oldResult = null;
                } while (i < nCells);
            }
        }
    }

    private void generateDeletes(PhoenixIndexMetaData indexMetaData, Collection<Pair<Mutation, byte[]>> indexUpdates, byte[] attribValue, TxTableState state2) throws IOException {
        byte[] regionStartKey = this.regionStartKey;
        byte[] regionEndKey = this.regionEndKey;
        if (this.services != null && indexMetaData.hasLocalIndexes()) {
            try {
                HRegionLocation tableRegionLocation = this.services.getTableRegionLocation(this.tableName, state2.getCurrentRowKey());
                regionStartKey = tableRegionLocation.getRegionInfo().getStartKey();
                regionEndKey = tableRegionLocation.getRegionInfo().getEndKey();
            }
            catch (SQLException e) {
                throw new IOException(e);
            }
        }
        Iterable<IndexUpdate> deletes = this.codec.getIndexDeletes(state2, indexMetaData, regionStartKey, regionEndKey);
        for (IndexUpdate delete : deletes) {
            if (!delete.isValid()) continue;
            delete.getUpdate().setAttribute("tephra.tx.rollback", attribValue);
            indexUpdates.add((Pair<Mutation, byte[]>)new Pair((Object)delete.getUpdate(), (Object)delete.getTableName()));
        }
    }

    private boolean generatePuts(PhoenixIndexMetaData indexMetaData, Collection<Pair<Mutation, byte[]>> indexUpdates, TxTableState state2) throws IOException {
        state2.applyMutation();
        byte[] regionStartKey = this.regionStartKey;
        byte[] regionEndKey = this.regionEndKey;
        if (this.services != null && indexMetaData.hasLocalIndexes()) {
            try {
                HRegionLocation tableRegionLocation = this.services.getTableRegionLocation(this.tableName, state2.getCurrentRowKey());
                regionStartKey = tableRegionLocation.getRegionInfo().getStartKey();
                regionEndKey = tableRegionLocation.getRegionInfo().getEndKey();
            }
            catch (SQLException e) {
                throw new IOException(e);
            }
        }
        Iterable<IndexUpdate> puts = this.codec.getIndexUpserts(state2, indexMetaData, regionStartKey, regionEndKey);
        boolean validPut = false;
        for (IndexUpdate put : puts) {
            if (!put.isValid()) continue;
            indexUpdates.add((Pair<Mutation, byte[]>)new Pair((Object)put.getUpdate(), (Object)put.getTableName()));
            validPut = true;
        }
        return validPut;
    }

    public static PhoenixTxIndexMutationGenerator newGenerator(final PhoenixConnection connection, PTable table, List<PTable> indexes, Map<String, byte[]> attributes) {
        final ArrayList indexMaintainers = Lists.newArrayListWithExpectedSize((int)indexes.size());
        for (PTable index : indexes) {
            IndexMaintainer maintainer = index.getIndexMaintainer(table, connection);
            indexMaintainers.add(maintainer);
        }
        IndexMetaDataCache indexMetaDataCache = new IndexMetaDataCache(){

            @Override
            public void close() throws IOException {
            }

            @Override
            public List<IndexMaintainer> getIndexMaintainers() {
                return indexMaintainers;
            }

            @Override
            public PhoenixTransactionContext getTransactionContext() {
                PhoenixTransactionContext context = connection.getMutationState().getPhoenixTransactionContext();
                return context.newTransactionContext(context, true);
            }

            @Override
            public int getClientVersion() {
                return MetaDataProtocol.PHOENIX_VERSION;
            }
        };
        try {
            PhoenixIndexMetaData indexMetaData = new PhoenixIndexMetaData(indexMetaDataCache, attributes);
            return new PhoenixTxIndexMutationGenerator(connection.getQueryServices(), connection.getQueryServices().getConfiguration(), indexMetaData, table.getPhysicalName().getBytes(), null, null);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static class TxTableState
    implements TableState {
        private final Mutation mutation;
        private final long currentTimestamp;
        private final List<Cell> pendingUpdates;
        private final Set<ColumnReference> indexedColumns;
        private final Map<ColumnReference, ImmutableBytesWritable> valueMap;

        private TxTableState(Set<ColumnReference> indexedColumns, long currentTimestamp, Mutation mutation) {
            this.currentTimestamp = currentTimestamp;
            this.indexedColumns = indexedColumns;
            this.mutation = mutation;
            int estimatedSize = indexedColumns.size();
            this.valueMap = Maps.newHashMapWithExpectedSize((int)estimatedSize);
            this.pendingUpdates = Lists.newArrayListWithExpectedSize((int)estimatedSize);
            try {
                CellScanner scanner = mutation.cellScanner();
                while (scanner.advance()) {
                    Cell cell = scanner.current();
                    this.pendingUpdates.add((Cell)PhoenixKeyValueUtil.maybeCopyCell(cell));
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public TxTableState(Set<ColumnReference> indexedColumns, long currentTimestamp, Mutation m, ColumnReference emptyColRef, Result r) {
            this(indexedColumns, currentTimestamp, m);
            for (ColumnReference ref : indexedColumns) {
                Cell cell = r.getColumnLatestCell(ref.getFamily(), ref.getQualifier());
                if (cell == null) continue;
                ImmutableBytesWritable ptr = new ImmutableBytesWritable();
                ptr.set(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength());
                this.valueMap.put(ref, ptr);
            }
        }

        @Override
        public long getCurrentTimestamp() {
            return this.currentTimestamp;
        }

        @Override
        public byte[] getCurrentRowKey() {
            return this.mutation.getRow();
        }

        @Override
        public List<? extends IndexedColumnGroup> getIndexColumnHints() {
            return Collections.emptyList();
        }

        private void applyMutation() {
            for (Cell cell : this.pendingUpdates) {
                Object ref;
                if (cell.getTypeByte() == KeyValue.Type.Delete.getCode() || cell.getTypeByte() == KeyValue.Type.DeleteColumn.getCode()) {
                    ref = new ColumnReference(cell.getFamilyArray(), cell.getFamilyOffset(), cell.getFamilyLength(), cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength());
                    this.valueMap.remove(ref);
                    continue;
                }
                if (cell.getTypeByte() == KeyValue.Type.DeleteFamily.getCode() || cell.getTypeByte() == KeyValue.Type.DeleteFamilyVersion.getCode()) {
                    for (ColumnReference ref2 : this.indexedColumns) {
                        if (!ref2.matchesFamily(cell.getFamilyArray(), cell.getFamilyOffset(), cell.getFamilyLength())) continue;
                        this.valueMap.remove(ref2);
                    }
                    continue;
                }
                if (cell.getTypeByte() == KeyValue.Type.Put.getCode()) {
                    ref = new ColumnReference(cell.getFamilyArray(), cell.getFamilyOffset(), cell.getFamilyLength(), cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength());
                    if (!this.indexedColumns.contains(ref)) continue;
                    ImmutableBytesWritable ptr = new ImmutableBytesWritable();
                    ptr.set(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength());
                    this.valueMap.put((ColumnReference)ref, ptr);
                    continue;
                }
                throw new IllegalStateException("Unexpected mutation type for " + cell);
            }
        }

        @Override
        public Collection<Cell> getPendingUpdate() {
            return this.pendingUpdates;
        }

        @Override
        public Pair<ValueGetter, IndexUpdate> getIndexUpdateState(Collection<? extends ColumnReference> indexedColumns, boolean ignoreNewerMutations, boolean returnNullScannerIfRowNotFound, IndexMetaData indexMetaData) throws IOException {
            ColumnTracker tracker = new ColumnTracker(indexedColumns);
            AbstractValueGetter getter = new AbstractValueGetter(){

                @Override
                public ImmutableBytesWritable getLatestValue(ColumnReference ref, long ts) throws IOException {
                    return (ImmutableBytesWritable)valueMap.get(ref);
                }

                @Override
                public byte[] getRowKey() {
                    return mutation.getRow();
                }
            };
            Pair pair = new Pair((Object)getter, (Object)new IndexUpdate(tracker));
            return pair;
        }
    }
}

