/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.coprocessor;

import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.BitSet;
import org.apache.phoenix.compile.ColumnResolver;
import org.apache.phoenix.compile.CreateTableCompiler;
import org.apache.phoenix.compile.FromCompiler;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.compile.WhereCompiler;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.parse.ParseNode;
import org.apache.phoenix.parse.SQLParser;
import org.apache.phoenix.parse.SelectStatement;
import org.apache.phoenix.schema.ColumnNotFoundException;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PColumnImpl;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableImpl;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.util.MetaDataUtil;

public class WhereConstantParser {
    public static PTable addViewInfoToPColumnsIfNeeded(PTable view) throws SQLException {
        byte[][] viewColumnConstantsToBe = new byte[view.getColumns().size()][];
        if (view.getViewStatement() == null) {
            return view;
        }
        SelectStatement select = new SQLParser(view.getViewStatement()).parseQuery();
        ParseNode whereNode = select.getWhere();
        ColumnResolver resolver = FromCompiler.getResolver(new TableRef(view));
        try (PhoenixConnection conn = WhereConstantParser.getConnectionlessConnection();){
            Expression expression;
            StatementContext context = new StatementContext(new PhoenixStatement(conn), resolver);
            try {
                expression = WhereCompiler.compile(context, whereNode);
            }
            catch (ColumnNotFoundException e) {
                PTable pTable = null;
                if (conn != null) {
                    if (var6_6 != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable) {
                            var6_6.addSuppressed(throwable);
                        }
                    } else {
                        conn.close();
                    }
                }
                return pTable;
            }
            CreateTableCompiler.ViewWhereExpressionVisitor visitor = new CreateTableCompiler.ViewWhereExpressionVisitor(view, viewColumnConstantsToBe);
            expression.accept(visitor);
            BitSet isViewColumnReferencedToBe = new BitSet(view.getColumns().size());
            CreateTableCompiler.ColumnTrackingExpressionCompiler expressionCompiler = new CreateTableCompiler.ColumnTrackingExpressionCompiler(context, isViewColumnReferencedToBe);
            whereNode.accept(expressionCompiler);
            ArrayList result = Lists.newArrayList();
            for (PColumn column : PTableImpl.getColumnsToClone(view)) {
                boolean isViewReferenced = isViewColumnReferencedToBe.get(column.getPosition());
                if ((visitor.isUpdatable() || view.getPKColumns().get(MetaDataUtil.getAutoPartitionColIndex(view)).equals(column)) && viewColumnConstantsToBe[column.getPosition()] != null) {
                    result.add(new PColumnImpl(column, viewColumnConstantsToBe[column.getPosition()], isViewReferenced));
                    continue;
                }
                if (isViewReferenced) {
                    result.add(new PColumnImpl(column, column.getViewConstant(), isViewReferenced));
                    continue;
                }
                result.add(column);
            }
            PTableImpl pTableImpl = PTableImpl.builderWithColumns(view, result).build();
            return pTableImpl;
        }
    }

    private static PhoenixConnection getConnectionlessConnection() throws SQLException {
        return DriverManager.getConnection("jdbc:phoenix:none").unwrap(PhoenixConnection.class);
    }
}

