/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.coprocessor;

import com.google.protobuf.RpcCallback;
import com.google.protobuf.RpcController;
import com.google.protobuf.Service;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.coprocessor.CoprocessorException;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.phoenix.coprocessor.MetaDataEndpointImpl;
import org.apache.phoenix.coprocessor.PhoenixMetaDataCoprocessorHost;
import org.apache.phoenix.coprocessor.generated.MetaDataProtos;
import org.apache.phoenix.coprocessor.generated.TaskMetaDataProtos;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.protobuf.ProtobufUtil;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.MetaDataUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskMetaDataEndpoint
extends TaskMetaDataProtos.TaskMetaDataService
implements RegionCoprocessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskMetaDataEndpoint.class);
    private RegionCoprocessorEnvironment env;
    private PhoenixMetaDataCoprocessorHost phoenixAccessCoprocessorHost;
    private boolean accessCheckEnabled;

    public void start(CoprocessorEnvironment env) throws IOException {
        if (!(env instanceof RegionCoprocessorEnvironment)) {
            throw new CoprocessorException("Must be loaded on a table region!");
        }
        this.env = (RegionCoprocessorEnvironment)env;
        this.phoenixAccessCoprocessorHost = new PhoenixMetaDataCoprocessorHost(this.env);
        this.accessCheckEnabled = env.getConfiguration().getBoolean("phoenix.acls.enabled", false);
    }

    public Iterable<Service> getServices() {
        return Collections.singleton(this);
    }

    @Override
    public void upsertTaskDetails(RpcController controller, TaskMetaDataProtos.TaskMutateRequest request, RpcCallback<MetaDataProtos.MetaDataResponse> done) {
        MetaDataProtos.MetaDataResponse.Builder builder = MetaDataProtos.MetaDataResponse.newBuilder();
        try {
            List<Mutation> taskMutations = ProtobufUtil.getMutations(request);
            if (taskMutations.isEmpty()) {
                done.run((Object)builder.build());
                return;
            }
            byte[][] rowKeyMetaData = new byte[3][];
            MetaDataUtil.getTenantIdAndSchemaAndTableName(taskMutations, rowKeyMetaData);
            byte[] schemaName = rowKeyMetaData[1];
            byte[] tableName = rowKeyMetaData[2];
            String fullTableName = SchemaUtil.getTableName(schemaName, tableName);
            this.phoenixAccessCoprocessorHost.preUpsertTaskDetails(fullTableName);
            MetaDataEndpointImpl.mutateRowsWithLocks(this.accessCheckEnabled, this.env.getRegion(), taskMutations, Collections.emptySet(), 0L, 0L);
        }
        catch (Throwable t) {
            LOGGER.error("Unable to write mutations to {}", (Object)PhoenixDatabaseMetaData.SYSTEM_TASK_NAME, (Object)t);
            builder.setReturnCode(MetaDataProtos.MutationCode.UNABLE_TO_UPSERT_TASK);
            builder.setMutationTime(EnvironmentEdgeManager.currentTimeMillis());
            done.run((Object)builder.build());
        }
    }
}

