/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.compile;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.jcip.annotations.Immutable;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.compile.ExplainPlanAttributes;
import org.apache.phoenix.compile.ExpressionCompiler;
import org.apache.phoenix.compile.OrderByCompiler;
import org.apache.phoenix.compile.OrderPreservingTracker;
import org.apache.phoenix.compile.QueryPlan;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.expression.CoerceExpression;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.parse.AliasedNode;
import org.apache.phoenix.parse.DistinctCountParseNode;
import org.apache.phoenix.parse.HintNode;
import org.apache.phoenix.parse.ParseNode;
import org.apache.phoenix.parse.SelectStatement;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PVarbinary;
import org.apache.phoenix.thirdparty.com.google.common.collect.ImmutableList;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.util.IndexUtil;

public class GroupByCompiler {
    public static GroupBy compile(StatementContext context, SelectStatement statement) throws SQLException {
        ArrayList groupByNodes = statement.getGroupBy();
        boolean isUngroupedAggregate = false;
        if (groupByNodes.isEmpty()) {
            if (statement.isAggregate()) {
                if (statement.getHint().hasHint(HintNode.Hint.RANGE_SCAN) || statement.getHaving() != null) {
                    return GroupBy.UNGROUPED_GROUP_BY;
                }
                groupByNodes = Lists.newArrayListWithExpectedSize((int)statement.getSelect().size());
                for (AliasedNode aliasedNode : statement.getSelect()) {
                    if (aliasedNode.getNode() instanceof DistinctCountParseNode) {
                        groupByNodes.addAll(aliasedNode.getNode().getChildren());
                        continue;
                    }
                    return GroupBy.UNGROUPED_GROUP_BY;
                }
                isUngroupedAggregate = true;
            } else if (statement.isDistinct()) {
                groupByNodes = Lists.newArrayListWithExpectedSize((int)statement.getSelect().size());
                for (AliasedNode aliasedNode : statement.getSelect()) {
                    groupByNodes.add(aliasedNode.getNode());
                }
            } else {
                return GroupBy.EMPTY_GROUP_BY;
            }
        }
        ExpressionCompiler compiler = new ExpressionCompiler(context, GroupBy.EMPTY_GROUP_BY);
        ArrayList expressions = Lists.newArrayListWithExpectedSize((int)groupByNodes.size());
        for (int i = 0; i < groupByNodes.size(); ++i) {
            ParseNode node = (ParseNode)groupByNodes.get(i);
            Expression expression = node.accept(compiler);
            if (!expression.isStateless()) {
                if (compiler.isAggregate()) {
                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.AGGREGATE_IN_GROUP_BY).setMessage(expression.toString()).build().buildException();
                }
                expressions.add(expression);
            }
            compiler.reset();
        }
        if (expressions.isEmpty()) {
            return GroupBy.EMPTY_GROUP_BY;
        }
        GroupBy groupBy = new GroupBy.GroupByBuilder().setIsOrderPreserving(OrderByCompiler.isTrackOrderByPreserving(statement)).setExpressions(expressions).setKeyExpressions(expressions).setIsUngroupedAggregate(isUngroupedAggregate).build();
        return groupBy;
    }

    private static boolean onlyAtEndType(Expression expression) {
        PDataType type = GroupByCompiler.getGroupByDataType(expression);
        return type.isArrayType() || type == PVarbinary.INSTANCE;
    }

    private static PDataType getGroupByDataType(Expression expression) {
        return IndexUtil.getIndexColumnDataType(expression.isNullable(), expression.getDataType());
    }

    private GroupByCompiler() {
    }

    @Immutable
    public static class GroupBy {
        private final List<Expression> expressions;
        private final List<Expression> keyExpressions;
        private final boolean isOrderPreserving;
        private final int orderPreservingColumnCount;
        private final boolean isUngroupedAggregate;
        private final List<OrderPreservingTracker.Info> orderPreservingTrackInfos;
        public static final GroupBy EMPTY_GROUP_BY = new GroupBy(new GroupByBuilder()){

            @Override
            public GroupBy compile(StatementContext context, QueryPlan innerQueryPlan, Expression whereExpression) throws SQLException {
                return this;
            }

            @Override
            public void explain(List<String> planSteps, Integer limit) {
            }

            @Override
            public void explain(List<String> planSteps, Integer limit, ExplainPlanAttributes.ExplainPlanAttributesBuilder explainPlanAttributesBuilder) {
            }

            @Override
            public String getScanAttribName() {
                return null;
            }
        };
        public static final GroupBy UNGROUPED_GROUP_BY = new GroupBy(new GroupByBuilder().setIsOrderPreserving(true).setIsUngroupedAggregate(true)){

            @Override
            public GroupBy compile(StatementContext context, QueryPlan innerQueryPlan, Expression whereExpression) throws SQLException {
                return this;
            }

            @Override
            public void explain(List<String> planSteps, Integer limit) {
                planSteps.add("    SERVER AGGREGATE INTO SINGLE ROW");
            }

            @Override
            public void explain(List<String> planSteps, Integer limit, ExplainPlanAttributes.ExplainPlanAttributesBuilder explainPlanAttributesBuilder) {
                planSteps.add("    SERVER AGGREGATE INTO SINGLE ROW");
                if (explainPlanAttributesBuilder != null) {
                    explainPlanAttributesBuilder.setServerAggregate("SERVER AGGREGATE INTO SINGLE ROW");
                }
            }

            @Override
            public String getScanAttribName() {
                return "_UngroupedAgg";
            }
        };

        private GroupBy(GroupByBuilder builder) {
            this.expressions = ImmutableList.copyOf((Collection)builder.expressions);
            this.keyExpressions = builder.expressions == builder.keyExpressions ? this.expressions : (builder.keyExpressions == null ? null : ImmutableList.copyOf((Collection)builder.keyExpressions));
            this.isOrderPreserving = builder.isOrderPreserving;
            this.orderPreservingColumnCount = builder.orderPreservingColumnCount;
            this.isUngroupedAggregate = builder.isUngroupedAggregate;
            this.orderPreservingTrackInfos = builder.orderPreservingTrackInfos;
        }

        public List<Expression> getExpressions() {
            return this.expressions;
        }

        public List<Expression> getKeyExpressions() {
            return this.keyExpressions;
        }

        public String getScanAttribName() {
            if (this.isUngroupedAggregate) {
                return "_UngroupedAgg";
            }
            if (this.isOrderPreserving) {
                return "_OrderedGroupByExpressions";
            }
            return "_UnorderedGroupByExpressions";
        }

        public boolean isEmpty() {
            return this.expressions.isEmpty();
        }

        public boolean isOrderPreserving() {
            return this.isOrderPreserving;
        }

        public boolean isUngroupedAggregate() {
            return this.isUngroupedAggregate;
        }

        public int getOrderPreservingColumnCount() {
            return this.orderPreservingColumnCount;
        }

        public List<OrderPreservingTracker.Info> getOrderPreservingTrackInfos() {
            return this.orderPreservingTrackInfos;
        }

        public GroupBy compile(StatementContext context, QueryPlan innerQueryPlan, Expression whereExpression) throws SQLException {
            ArrayList<Expression> expressions;
            boolean isOrderPreserving = this.isOrderPreserving;
            int orderPreservingColumnCount = 0;
            if (isOrderPreserving) {
                OrderPreservingTracker tracker = new OrderPreservingTracker(context, EMPTY_GROUP_BY, OrderPreservingTracker.Ordering.UNORDERED, this.expressions.size(), null, innerQueryPlan, whereExpression);
                for (int i = 0; i < this.expressions.size(); ++i) {
                    Expression expression = this.expressions.get(i);
                    tracker.track(expression);
                }
                isOrderPreserving = tracker.isOrderPreserving();
                orderPreservingColumnCount = tracker.getOrderPreservingColumnCount();
                if (isOrderPreserving) {
                    List<OrderPreservingTracker.Info> orderPreservingTrackInfos = tracker.getOrderPreservingTrackInfos();
                    List<Expression> newExpressions = OrderPreservingTracker.Info.extractExpressions(orderPreservingTrackInfos);
                    assert (newExpressions.size() == this.expressions.size());
                    return new GroupByBuilder(this).setIsOrderPreserving(isOrderPreserving).setOrderPreservingColumnCount(orderPreservingColumnCount).setExpressions(newExpressions).setKeyExpressions(newExpressions).setOrderPreservingTrackInfos(orderPreservingTrackInfos).build();
                }
            }
            if (this.isUngroupedAggregate) {
                return new GroupByBuilder(this).setIsOrderPreserving(isOrderPreserving).setOrderPreservingColumnCount(orderPreservingColumnCount).build();
            }
            ArrayList<Expression> keyExpressions = expressions = Lists.newArrayListWithExpectedSize((int)this.expressions.size());
            ArrayList groupBys = Lists.newArrayListWithExpectedSize((int)this.expressions.size());
            for (int i = 0; i < this.expressions.size(); ++i) {
                Expression expression = this.expressions.get(i);
                groupBys.add(new Pair((Object)i, (Object)expression));
            }
            Collections.sort(groupBys, new Comparator<Pair<Integer, Expression>>(){

                @Override
                public int compare(Pair<Integer, Expression> gb1, Pair<Integer, Expression> gb2) {
                    boolean oae2;
                    Expression e1 = (Expression)gb1.getSecond();
                    Expression e2 = (Expression)gb2.getSecond();
                    PDataType t1 = e1.getDataType();
                    PDataType t2 = e2.getDataType();
                    boolean isFixed1 = t1.isFixedWidth();
                    boolean isFixed2 = t2.isFixedWidth();
                    boolean isFixedNullable1 = e1.isNullable() && isFixed1;
                    boolean isFixedNullable2 = e2.isNullable() && isFixed2;
                    boolean oae1 = GroupByCompiler.onlyAtEndType(e1);
                    if (oae1 == (oae2 = GroupByCompiler.onlyAtEndType(e2))) {
                        if (isFixedNullable1 == isFixedNullable2) {
                            if (isFixed1 == isFixed2) {
                                return (Integer)gb1.getFirst() - (Integer)gb2.getFirst();
                            }
                            if (isFixed1) {
                                return -1;
                            }
                            return 1;
                        }
                        if (isFixedNullable1) {
                            return 1;
                        }
                        return -1;
                    }
                    if (oae1) {
                        return 1;
                    }
                    return -1;
                }
            });
            boolean foundOnlyAtEndType = false;
            for (Pair groupBy : groupBys) {
                Expression e = (Expression)groupBy.getSecond();
                if (GroupByCompiler.onlyAtEndType(e)) {
                    if (foundOnlyAtEndType) {
                        throw new SQLExceptionInfo.Builder(SQLExceptionCode.UNSUPPORTED_GROUP_BY_EXPRESSIONS).setMessage(e.toString()).build().buildException();
                    }
                    foundOnlyAtEndType = true;
                }
                expressions.add(e);
            }
            for (int i = expressions.size() - 2; i >= 0; --i) {
                Expression expression = (Expression)expressions.get(i);
                PDataType keyType = GroupByCompiler.getGroupByDataType(expression);
                if (keyType == expression.getDataType()) continue;
                if (keyExpressions == expressions) {
                    keyExpressions = new ArrayList<Expression>(expressions);
                }
                keyExpressions.set(i, CoerceExpression.create(expression, keyType));
            }
            GroupBy groupBy = new GroupByBuilder().setIsOrderPreserving(isOrderPreserving).setExpressions((List<Expression>)expressions).setKeyExpressions((List<Expression>)keyExpressions).build();
            return groupBy;
        }

        public void explain(List<String> planSteps, Integer limit) {
            this.explainUtil(planSteps, limit, null);
        }

        private void explainUtil(List<String> planSteps, Integer limit, ExplainPlanAttributes.ExplainPlanAttributesBuilder explainPlanAttributesBuilder) {
            String serverAggregate;
            if (this.isUngroupedAggregate) {
                serverAggregate = "SERVER AGGREGATE INTO SINGLE ROW";
            } else {
                String groupLimit = limit == null ? "" : " LIMIT " + limit + " GROUP" + (limit == 1 ? "" : "S");
                serverAggregate = this.isOrderPreserving ? "SERVER AGGREGATE INTO ORDERED DISTINCT ROWS BY " + this.getExpressions() + groupLimit : "SERVER AGGREGATE INTO DISTINCT ROWS BY " + this.getExpressions() + groupLimit;
            }
            planSteps.add("    " + serverAggregate);
            if (explainPlanAttributesBuilder != null) {
                explainPlanAttributesBuilder.setServerAggregate(serverAggregate);
            }
        }

        public void explain(List<String> planSteps, Integer limit, ExplainPlanAttributes.ExplainPlanAttributesBuilder explainPlanAttributesBuilder) {
            this.explainUtil(planSteps, limit, explainPlanAttributesBuilder);
        }

        public static class GroupByBuilder {
            private boolean isOrderPreserving;
            private int orderPreservingColumnCount;
            private List<Expression> expressions = Collections.emptyList();
            private List<Expression> keyExpressions = Collections.emptyList();
            private boolean isUngroupedAggregate;
            private List<OrderPreservingTracker.Info> orderPreservingTrackInfos = Collections.emptyList();

            public GroupByBuilder() {
            }

            public GroupByBuilder(GroupBy groupBy) {
                this.isOrderPreserving = groupBy.isOrderPreserving;
                this.orderPreservingColumnCount = groupBy.orderPreservingColumnCount;
                this.expressions = groupBy.expressions;
                this.keyExpressions = groupBy.keyExpressions;
                this.isUngroupedAggregate = groupBy.isUngroupedAggregate;
            }

            public GroupByBuilder setExpressions(List<Expression> expressions) {
                this.expressions = expressions;
                return this;
            }

            public GroupByBuilder setKeyExpressions(List<Expression> keyExpressions) {
                this.keyExpressions = keyExpressions;
                return this;
            }

            public GroupByBuilder setIsOrderPreserving(boolean isOrderPreserving) {
                this.isOrderPreserving = isOrderPreserving;
                return this;
            }

            public GroupByBuilder setIsUngroupedAggregate(boolean isUngroupedAggregate) {
                this.isUngroupedAggregate = isUngroupedAggregate;
                return this;
            }

            public GroupByBuilder setOrderPreservingColumnCount(int orderPreservingColumnCount) {
                this.orderPreservingColumnCount = orderPreservingColumnCount;
                return this;
            }

            public GroupByBuilder setOrderPreservingTrackInfos(List<OrderPreservingTracker.Info> orderPreservingTrackInfos) {
                this.orderPreservingTrackInfos = orderPreservingTrackInfos;
                return this;
            }

            public GroupBy build() {
                return new GroupBy(this);
            }
        }
    }
}

