/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.cache.aggcache;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Map;
import java.util.UUID;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.util.Closeables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpillFile
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpillFile.class);
    private static final int SPILL_FILE_SIZE = Integer.MAX_VALUE;
    static final int DEFAULT_PAGE_SIZE = 4096;
    private Map<Integer, TempFile> tempFiles;
    private File spillFilesDirectory = null;

    private SpillFile(File spillFilesDirectory) throws IOException {
        this.spillFilesDirectory = spillFilesDirectory;
        this.tempFiles = Maps.newHashMap();
        this.tempFiles.put(0, this.createTempFile());
    }

    public static SpillFile createSpillFile(File spillFilesDir) {
        try {
            return new SpillFile(spillFilesDir);
        }
        catch (IOException ioe) {
            throw new RuntimeException("Could not create Spillfile " + ioe);
        }
    }

    private TempFile createTempFile() throws IOException {
        File tempFile = File.createTempFile(UUID.randomUUID().toString(), null, this.spillFilesDirectory);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Creating new SpillFile: " + tempFile.getAbsolutePath());
        }
        RandomAccessFile file = new RandomAccessFile(tempFile, "rw");
        file.setLength(Integer.MAX_VALUE);
        return new TempFile(tempFile, file);
    }

    public RandomAccessFile getPage(int index) {
        try {
            TempFile tempFile = null;
            int fileIndex = 0;
            long offset = (long)index * 4096L;
            if (offset >= Integer.MAX_VALUE && !this.tempFiles.containsKey(fileIndex = (int)(offset / Integer.MAX_VALUE))) {
                tempFile = this.createTempFile();
                this.tempFiles.put(fileIndex, tempFile);
            }
            tempFile = this.tempFiles.get(fileIndex);
            RandomAccessFile file = tempFile.rndFile;
            file.seek(offset);
            return file;
        }
        catch (IOException ioe) {
            this.close();
            throw new RuntimeException("Could not get page at index: " + index);
        }
        catch (IllegalArgumentException iae) {
            this.close();
            throw iae;
        }
    }

    @Override
    public void close() {
        for (TempFile file : this.tempFiles.values()) {
            Closeables.closeQuietly(file);
        }
    }

    private static class TempFile
    implements Closeable {
        private final RandomAccessFile rndFile;
        private final File file;

        public TempFile(File file, RandomAccessFile rndFile) {
            this.file = file;
            this.rndFile = rndFile;
        }

        @Override
        public void close() throws IOException {
            Closeables.closeQuietly(this.rndFile.getChannel());
            Closeables.closeQuietly(this.rndFile);
            if (this.file != null) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Deleting tempFile: " + this.file.getAbsolutePath());
                }
                try {
                    this.file.delete();
                }
                catch (SecurityException e) {
                    LOGGER.warn("IOException thrown while closing Closeable." + e);
                }
            }
        }
    }
}

