/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.FSDataInputStreamWrapper;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.io.Reference;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.regionserver.LocalIndexStoreFileScanner;
import org.apache.hadoop.hbase.regionserver.StoreFileScanner;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.compat.hbase.CompatStoreFileReader;
import org.apache.phoenix.index.IndexMaintainer;

public class IndexHalfStoreFileReader
extends CompatStoreFileReader {
    private final boolean top;
    private final byte[] splitkey;
    private final byte[] splitRow;
    private final Map<ImmutableBytesWritable, IndexMaintainer> indexMaintainers;
    private final byte[][] viewConstants;
    private final int offset;
    private final RegionInfo childRegionInfo;
    private final byte[] regionStartKeyInHFile;
    private final AtomicInteger refCount;
    private final RegionInfo currentRegion;

    public IndexHalfStoreFileReader(FileSystem fs, Path p, CacheConfig cacheConf, FSDataInputStreamWrapper in, long size, Reference r, Configuration conf, Map<ImmutableBytesWritable, IndexMaintainer> indexMaintainers, byte[][] viewConstants, RegionInfo regionInfo, byte[] regionStartKeyInHFile, byte[] splitKey, boolean primaryReplicaStoreFile, AtomicInteger refCount, RegionInfo currentRegion) throws IOException {
        super(fs, p, in, size, cacheConf, primaryReplicaStoreFile, refCount, conf);
        this.splitkey = splitKey == null ? r.getSplitKey() : splitKey;
        this.top = Reference.isTopFileRegion((Reference.Range)r.getFileRegion());
        this.splitRow = CellUtil.cloneRow((Cell)new KeyValue.KeyOnlyKeyValue(this.splitkey));
        this.indexMaintainers = indexMaintainers;
        this.viewConstants = viewConstants;
        this.childRegionInfo = regionInfo;
        this.regionStartKeyInHFile = regionStartKeyInHFile;
        this.offset = regionStartKeyInHFile.length;
        this.refCount = refCount;
        this.currentRegion = currentRegion;
    }

    public int getOffset() {
        return this.offset;
    }

    public byte[][] getViewConstants() {
        return this.viewConstants;
    }

    public Map<ImmutableBytesWritable, IndexMaintainer> getIndexMaintainers() {
        return this.indexMaintainers;
    }

    public RegionInfo getRegionInfo() {
        return this.childRegionInfo;
    }

    public byte[] getRegionStartKeyInHFile() {
        return this.regionStartKeyInHFile;
    }

    public byte[] getSplitkey() {
        return this.splitkey;
    }

    public byte[] getSplitRow() {
        return this.splitRow;
    }

    public boolean isTop() {
        return this.top;
    }

    public StoreFileScanner getStoreFileScanner(boolean cacheBlocks, boolean pread, boolean isCompaction, long readPt, long scannerOrder, boolean canOptimizeForNonNullColumn) {
        this.refCount.incrementAndGet();
        return new LocalIndexStoreFileScanner(this, cacheBlocks, pread, isCompaction, readPt, scannerOrder, canOptimizeForNonNullColumn);
    }

    public boolean passesKeyRangeFilter(Scan scan) {
        if (scan.getAttribute("_ScanStartRowSuffix") == null) {
            return true;
        }
        byte[] startKey = this.currentRegion.getStartKey();
        byte[] endKey = this.currentRegion.getEndKey();
        int prefixLength = scan.getStartRow().length - scan.getAttribute("_ScanStartRowSuffix").length;
        return Bytes.compareTo((byte[])scan.getStartRow(), (int)0, (int)prefixLength, (byte[])(startKey.length == 0 ? new byte[endKey.length] : startKey), (int)0, (int)(startKey.length == 0 ? endKey.length : startKey.length)) == 0;
    }
}

