/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.metastore.expressions;

import java.util.List;
import java.util.StringJoiner;
import org.apache.drill.metastore.MetastoreColumn;
import org.apache.drill.metastore.expressions.FilterExpression;

public abstract class ListPredicate<T>
implements FilterExpression {
    private final MetastoreColumn column;
    private final FilterExpression.Operator operator;
    private final List<T> values;

    protected ListPredicate(MetastoreColumn column, FilterExpression.Operator operator, List<T> values) {
        this.column = column;
        this.operator = operator;
        this.values = values;
    }

    public MetastoreColumn column() {
        return this.column;
    }

    public List<T> values() {
        return this.values;
    }

    @Override
    public FilterExpression.Operator operator() {
        return this.operator;
    }

    public String toString() {
        return new StringJoiner(", ", ListPredicate.class.getSimpleName() + "[", "]").add("column=" + (Object)((Object)this.column)).add("operator=" + (Object)((Object)this.operator)).add("values=" + this.values).toString();
    }

    public static class NotIn<T>
    extends ListPredicate<T> {
        public NotIn(MetastoreColumn column, List<T> values) {
            super(column, FilterExpression.Operator.NOT_IN, values);
        }

        public <V> V accept(FilterExpression.Visitor<V> visitor) {
            return visitor.visit(this);
        }
    }

    public static class In<T>
    extends ListPredicate<T> {
        public In(MetastoreColumn column, List<T> values) {
            super(column, FilterExpression.Operator.IN, values);
        }

        public <V> V accept(FilterExpression.Visitor<V> visitor) {
            return visitor.visit(this);
        }
    }
}

