/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.mongo;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;
import org.apache.drill.shaded.guava.com.google.common.collect.Maps;
import org.bson.Document;

public class MongoUtils {
    public static Document andFilterAtIndex(Document leftFilter, Document rightFilter) {
        Document andQueryFilter = new Document();
        ArrayList<Document> filters = new ArrayList<Document>();
        filters.add(leftFilter);
        filters.add(rightFilter);
        andQueryFilter.put("$and", filters);
        return andQueryFilter;
    }

    public static Document orFilterAtIndex(Document leftFilter, Document rightFilter) {
        Document orQueryFilter = new Document();
        ArrayList<Document> filters = new ArrayList<Document>();
        filters.add(leftFilter);
        filters.add(rightFilter);
        orQueryFilter.put("$or", filters);
        return orQueryFilter;
    }

    public static Map<String, List<Document>> mergeFilters(Map<String, Object> minFilters, Map<String, Object> maxFilters) {
        List list;
        HashMap filters = Maps.newHashMap();
        for (Map.Entry<String, Object> entry : minFilters.entrySet()) {
            list = (List)filters.get(entry.getKey());
            if (list == null) {
                list = Lists.newArrayList();
                filters.put(entry.getKey(), list);
            }
            list.add(new Document(entry.getKey(), (Object)new Document("$gte", entry.getValue())));
        }
        for (Map.Entry<String, Object> entry : maxFilters.entrySet()) {
            list = (List)filters.get(entry.getKey());
            if (list == null) {
                list = Lists.newArrayList();
                filters.put(entry.getKey(), list);
            }
            list.add(new Document(entry.getKey(), (Object)new Document("$lt", entry.getValue())));
        }
        return filters;
    }
}

