/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.mongo;

import com.fasterxml.jackson.core.type.TypeReference;
import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.drill.common.JSONOptions;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.common.logical.security.CredentialsProvider;
import org.apache.drill.common.logical.security.PlainCredentialsProvider;
import org.apache.drill.exec.ops.OptimizerRulesContext;
import org.apache.drill.exec.physical.base.AbstractGroupScan;
import org.apache.drill.exec.planner.PlannerPhase;
import org.apache.drill.exec.server.DrillbitContext;
import org.apache.drill.exec.store.AbstractStoragePlugin;
import org.apache.drill.exec.store.PluginRulesProvider;
import org.apache.drill.exec.store.PluginRulesProviderImpl;
import org.apache.drill.exec.store.SchemaConfig;
import org.apache.drill.exec.store.StoragePluginRulesSupplier;
import org.apache.drill.exec.store.mongo.MongoCnxnKey;
import org.apache.drill.exec.store.mongo.MongoGroupScan;
import org.apache.drill.exec.store.mongo.MongoScanSpec;
import org.apache.drill.exec.store.mongo.MongoStoragePluginConfig;
import org.apache.drill.exec.store.mongo.plan.MongoPluginImplementor;
import org.apache.drill.exec.store.mongo.schema.MongoSchemaFactory;
import org.apache.drill.exec.store.plan.rel.PluginRel;
import org.apache.drill.exec.store.security.HadoopCredentialsProvider;
import org.apache.drill.exec.store.security.UsernamePasswordCredentials;
import org.apache.drill.shaded.guava.com.google.common.cache.Cache;
import org.apache.drill.shaded.guava.com.google.common.cache.CacheBuilder;
import org.apache.drill.shaded.guava.com.google.common.cache.RemovalListener;
import org.apache.drill.shaded.guava.com.google.common.cache.RemovalNotification;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableMap;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoStoragePlugin
extends AbstractStoragePlugin {
    private static final Logger logger = LoggerFactory.getLogger(MongoStoragePlugin.class);
    private final MongoStoragePluginConfig mongoConfig;
    private final MongoSchemaFactory schemaFactory;
    private final Cache<MongoCnxnKey, MongoClient> addressClientMap;
    private final ConnectionString clientURI;
    private final StoragePluginRulesSupplier storagePluginRulesSupplier;

    public MongoStoragePlugin(MongoStoragePluginConfig mongoConfig, DrillbitContext context, String name) {
        super(context, name);
        this.mongoConfig = mongoConfig;
        String connection = this.addCredentialsFromCredentialsProvider(this.mongoConfig.getConnection(), name);
        this.clientURI = new ConnectionString(connection);
        this.addressClientMap = CacheBuilder.newBuilder().expireAfterAccess(24L, TimeUnit.HOURS).removalListener((RemovalListener)new AddressCloser()).build();
        this.schemaFactory = new MongoSchemaFactory(this, name);
        this.storagePluginRulesSupplier = MongoStoragePlugin.storagePluginRulesSupplier(name, mongoConfig);
    }

    private static StoragePluginRulesSupplier storagePluginRulesSupplier(String name, MongoStoragePluginConfig mongoConfig) {
        Convention.Impl convention = new Convention.Impl("MONGO." + name, PluginRel.class);
        return StoragePluginRulesSupplier.builder().rulesProvider((PluginRulesProvider)new PluginRulesProviderImpl((Convention)convention, MongoPluginImplementor::new)).supportsProjectPushdown(mongoConfig.getPluginOptimizations().isSupportsProjectPushdown()).supportsSortPushdown(mongoConfig.getPluginOptimizations().isSupportsSortPushdown()).supportsAggregatePushdown(mongoConfig.getPluginOptimizations().isSupportsAggregatePushdown()).supportsFilterPushdown(mongoConfig.getPluginOptimizations().isSupportsFilterPushdown()).supportsLimitPushdown(mongoConfig.getPluginOptimizations().isSupportsLimitPushdown()).supportsUnionPushdown(mongoConfig.getPluginOptimizations().isSupportsUnionPushdown()).convention((Convention)convention).build();
    }

    private String addCredentialsFromCredentialsProvider(String connection, String name) {
        ConnectionString parsed = new ConnectionString(connection);
        if (parsed.getCredential() == null) {
            Optional<UsernamePasswordCredentials> credentials = this.getUsernamePasswordCredentials(name);
            try {
                if (credentials.isPresent()) {
                    String username = URLEncoder.encode(credentials.get().getUsername(), "UTF-8");
                    String password = URLEncoder.encode(credentials.get().getPassword(), "UTF-8");
                    return connection.replaceFirst("://", String.format("://%s:%s@", username, password));
                }
            }
            catch (IOException e) {
                logger.error("Error fetching mongodb username and password from configuration", (Throwable)e);
            }
        }
        return connection;
    }

    private Optional<UsernamePasswordCredentials> getUsernamePasswordCredentials(String name) {
        CredentialsProvider credentialsProvider = this.mongoConfig.getCredentialsProvider();
        if (credentialsProvider == null || credentialsProvider == PlainCredentialsProvider.EMPTY_CREDENTIALS_PROVIDER) {
            credentialsProvider = new HadoopCredentialsProvider((Map)ImmutableMap.of((Object)"username", (Object)("drill.exec.store." + name + ".username"), (Object)"password", (Object)("drill.exec.store." + name + ".password")));
        }
        return new UsernamePasswordCredentials.Builder().setCredentialsProvider(credentialsProvider).build();
    }

    public MongoStoragePluginConfig getConfig() {
        return this.mongoConfig;
    }

    public void registerSchemas(SchemaConfig schemaConfig, SchemaPlus parent) {
        this.schemaFactory.registerSchemas(schemaConfig, parent);
    }

    public boolean supportsRead() {
        return true;
    }

    public AbstractGroupScan getPhysicalScan(String userName, JSONOptions selection) throws IOException {
        MongoScanSpec mongoScanSpec = (MongoScanSpec)selection.getListWith((TypeReference)new TypeReference<MongoScanSpec>(){});
        return new MongoGroupScan(userName, this, mongoScanSpec, null, false);
    }

    public Set<? extends RelOptRule> getOptimizerRules(OptimizerRulesContext optimizerContext, PlannerPhase phase) {
        switch (phase) {
            case PHYSICAL: 
            case LOGICAL: {
                return this.storagePluginRulesSupplier.getOptimizerRules();
            }
        }
        return Collections.emptySet();
    }

    public Convention convention() {
        return this.storagePluginRulesSupplier.convention();
    }

    public MongoClient getClient() {
        List hosts = this.clientURI.getHosts();
        ArrayList addresses = Lists.newArrayList();
        for (String host : hosts) {
            addresses.add(new ServerAddress(host));
        }
        return this.getClient(addresses);
    }

    public synchronized MongoClient getClient(List<ServerAddress> addresses) {
        ServerAddress serverAddress = addresses.get(0);
        MongoCredential credential = this.clientURI.getCredential();
        String userName = credential == null ? null : credential.getUserName();
        MongoCnxnKey key = new MongoCnxnKey(serverAddress, userName);
        try {
            return (MongoClient)this.addressClientMap.get((Object)key, () -> {
                MongoClientSettings.Builder settings;
                if (this.clientURI.isSrvProtocol()) {
                    settings = MongoClientSettings.builder().applyConnectionString(this.clientURI);
                    logger.info("Created srv protocol connection to {}.", (Object)key);
                } else {
                    settings = MongoClientSettings.builder().applyToClusterSettings(builder -> builder.hosts(addresses));
                    if (credential != null) {
                        settings.credential(credential);
                    }
                    logger.info("Created connection to {}.", (Object)key);
                }
                logger.info("Number of open connections {}.", (Object)(this.addressClientMap.size() + 1L));
                return MongoClients.create((MongoClientSettings)settings.build());
            });
        }
        catch (ExecutionException e) {
            throw new DrillRuntimeException((Throwable)e);
        }
    }

    public void close() {
        this.addressClientMap.invalidateAll();
    }

    private static class AddressCloser
    implements RemovalListener<MongoCnxnKey, MongoClient> {
        private AddressCloser() {
        }

        public synchronized void onRemoval(RemovalNotification<MongoCnxnKey, MongoClient> removal) {
            ((MongoClient)removal.getValue()).close();
            logger.debug("Closed connection to {}.", (Object)((MongoCnxnKey)removal.getKey()).toString());
        }
    }
}

