/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector;

import hive.com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.type.DataTypePhysicalVariation;
import org.apache.hadoop.hive.common.type.Date;
import org.apache.hadoop.hive.common.type.HiveChar;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.common.type.HiveIntervalDayTime;
import org.apache.hadoop.hive.common.type.HiveIntervalYearMonth;
import org.apache.hadoop.hive.common.type.Timestamp;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.IntervalDayTimeColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedBatchUtil;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.io.HiveFileFormatUtils;
import org.apache.hadoop.hive.ql.io.IOPrepareCache;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.VirtualColumn;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.hive.serde2.io.DateWritableV2;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.CharTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.mapred.FileSplit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VectorizedRowBatchCtx {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger((String)VectorizedRowBatchCtx.class.getName());
    private String[] rowColumnNames;
    private TypeInfo[] rowColumnTypeInfos;
    private DataTypePhysicalVariation[] rowDataTypePhysicalVariations;
    private int[] dataColumnNums;
    private int dataColumnCount;
    private int partitionColumnCount;
    private int virtualColumnCount;
    private VirtualColumn[] neededVirtualColumns;
    private String[] scratchColumnTypeNames;
    private DataTypePhysicalVariation[] scratchDataTypePhysicalVariations;

    public VectorizedRowBatchCtx() {
    }

    public VectorizedRowBatchCtx(String[] rowColumnNames, TypeInfo[] rowColumnTypeInfos, DataTypePhysicalVariation[] rowDataTypePhysicalVariations, int[] dataColumnNums, int partitionColumnCount, int virtualColumnCount, VirtualColumn[] neededVirtualColumns, String[] scratchColumnTypeNames, DataTypePhysicalVariation[] scratchDataTypePhysicalVariations) {
        this.rowColumnNames = rowColumnNames;
        this.rowColumnTypeInfos = rowColumnTypeInfos;
        if (rowDataTypePhysicalVariations == null) {
            this.rowDataTypePhysicalVariations = new DataTypePhysicalVariation[rowColumnTypeInfos.length];
            Arrays.fill((Object[])this.rowDataTypePhysicalVariations, (Object)DataTypePhysicalVariation.NONE);
        } else {
            this.rowDataTypePhysicalVariations = rowDataTypePhysicalVariations;
        }
        this.dataColumnNums = dataColumnNums;
        this.partitionColumnCount = partitionColumnCount;
        if (neededVirtualColumns == null) {
            neededVirtualColumns = new VirtualColumn[]{};
        } else {
            this.neededVirtualColumns = neededVirtualColumns;
        }
        this.virtualColumnCount = virtualColumnCount;
        this.scratchColumnTypeNames = scratchColumnTypeNames;
        if (scratchDataTypePhysicalVariations == null) {
            this.scratchDataTypePhysicalVariations = new DataTypePhysicalVariation[scratchColumnTypeNames.length];
            Arrays.fill((Object[])this.scratchDataTypePhysicalVariations, (Object)DataTypePhysicalVariation.NONE);
        } else {
            this.scratchDataTypePhysicalVariations = scratchDataTypePhysicalVariations;
        }
        this.dataColumnCount = rowColumnTypeInfos.length - partitionColumnCount - virtualColumnCount;
    }

    public String[] getRowColumnNames() {
        return this.rowColumnNames;
    }

    public TypeInfo[] getRowColumnTypeInfos() {
        return this.rowColumnTypeInfos;
    }

    public DataTypePhysicalVariation[] getRowdataTypePhysicalVariations() {
        return this.rowDataTypePhysicalVariations;
    }

    public void setRowDataTypePhysicalVariations(DataTypePhysicalVariation[] rowDataTypePhysicalVariations) {
        this.rowDataTypePhysicalVariations = rowDataTypePhysicalVariations;
    }

    public int[] getDataColumnNums() {
        return this.dataColumnNums;
    }

    public int getDataColumnCount() {
        return this.dataColumnCount;
    }

    public int getPartitionColumnCount() {
        return this.partitionColumnCount;
    }

    public int getVirtualColumnCount() {
        return this.virtualColumnCount;
    }

    public VirtualColumn[] getNeededVirtualColumns() {
        return this.neededVirtualColumns;
    }

    public boolean isVirtualColumnNeeded(String virtualColumnName) {
        for (VirtualColumn neededVirtualColumn : this.neededVirtualColumns) {
            if (!neededVirtualColumn.getName().equals(virtualColumnName)) continue;
            return true;
        }
        return false;
    }

    public int findVirtualColumnNum(VirtualColumn virtualColumn) {
        int resultColumnNum = this.dataColumnCount + this.partitionColumnCount;
        for (VirtualColumn neededVirtualColumn : this.neededVirtualColumns) {
            if (neededVirtualColumn.equals((Object)virtualColumn)) {
                return resultColumnNum;
            }
            ++resultColumnNum;
        }
        return -1;
    }

    public String[] getScratchColumnTypeNames() {
        return this.scratchColumnTypeNames;
    }

    public DataTypePhysicalVariation[] getScratchDataTypePhysicalVariations() {
        return this.scratchDataTypePhysicalVariations;
    }

    public void init(StructObjectInspector structObjectInspector, String[] scratchColumnTypeNames) throws HiveException {
        this.rowColumnNames = VectorizedBatchUtil.columnNamesFromStructObjectInspector(structObjectInspector);
        this.rowColumnTypeInfos = VectorizedBatchUtil.typeInfosFromStructObjectInspector(structObjectInspector);
        this.dataColumnNums = null;
        this.partitionColumnCount = 0;
        this.virtualColumnCount = 0;
        this.neededVirtualColumns = new VirtualColumn[0];
        this.dataColumnCount = this.rowColumnTypeInfos.length;
        this.scratchColumnTypeNames = scratchColumnTypeNames;
        int scratchSize = scratchColumnTypeNames.length;
        this.scratchDataTypePhysicalVariations = new DataTypePhysicalVariation[scratchSize];
        Arrays.fill((Object[])this.scratchDataTypePhysicalVariations, (Object)DataTypePhysicalVariation.NONE);
    }

    public void init(StructObjectInspector structObjectInspector, String[] scratchColumnTypeNames, DataTypePhysicalVariation[] scratchDataTypePhysicalVariations) throws HiveException {
        this.rowColumnNames = VectorizedBatchUtil.columnNamesFromStructObjectInspector(structObjectInspector);
        this.rowColumnTypeInfos = VectorizedBatchUtil.typeInfosFromStructObjectInspector(structObjectInspector);
        this.dataColumnNums = null;
        this.partitionColumnCount = 0;
        this.virtualColumnCount = 0;
        this.neededVirtualColumns = new VirtualColumn[0];
        this.dataColumnCount = this.rowColumnTypeInfos.length;
        this.scratchColumnTypeNames = scratchColumnTypeNames;
        this.scratchDataTypePhysicalVariations = scratchDataTypePhysicalVariations;
    }

    public static void getPartitionValues(VectorizedRowBatchCtx vrbCtx, Configuration hiveConf, FileSplit split, Object[] partitionValues) throws IOException {
        MapWork mapWork = Utilities.getMapWork(hiveConf);
        VectorizedRowBatchCtx.getPartitionValues(vrbCtx, mapWork, split, partitionValues);
    }

    public static void getPartitionValues(VectorizedRowBatchCtx vrbCtx, MapWork mapWork, FileSplit split, Object[] partitionValues) throws IOException {
        LinkedHashMap<Path, PartitionDesc> pathToPartitionInfo = mapWork.getPathToPartitionInfo();
        PartitionDesc partDesc = HiveFileFormatUtils.getFromPathRecursively(pathToPartitionInfo, split.getPath(), IOPrepareCache.get().getPartitionDescMap());
        VectorizedRowBatchCtx.getPartitionValues(vrbCtx, partDesc, partitionValues);
    }

    public static void getPartitionValues(VectorizedRowBatchCtx vrbCtx, PartitionDesc partDesc, Object[] partitionValues) {
        LinkedHashMap<String, String> partSpec = partDesc.getPartSpec();
        for (int i = 0; i < vrbCtx.partitionColumnCount; ++i) {
            Object objectValue;
            if (partSpec == null) {
                objectValue = null;
            } else {
                String key = vrbCtx.rowColumnNames[vrbCtx.dataColumnCount + i];
                TypeInfo partColTypeInfo = vrbCtx.rowColumnTypeInfos[vrbCtx.dataColumnCount + i];
                ObjectInspector objectInspector = TypeInfoUtils.getStandardJavaObjectInspectorFromTypeInfo(partColTypeInfo);
                objectValue = ObjectInspectorConverters.getConverter((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, objectInspector).convert(partSpec.get(key));
                if (partColTypeInfo instanceof CharTypeInfo) {
                    objectValue = ((HiveChar)objectValue).getStrippedValue();
                }
            }
            partitionValues[i] = objectValue;
        }
    }

    private ColumnVector createColumnVectorFromRowColumnTypeInfos(int columnNum) {
        TypeInfo typeInfo = this.rowColumnTypeInfos[columnNum];
        DataTypePhysicalVariation dataTypePhysicalVariation = this.rowDataTypePhysicalVariations != null ? this.rowDataTypePhysicalVariations[columnNum] : DataTypePhysicalVariation.NONE;
        return VectorizedBatchUtil.createColumnVector(typeInfo, dataTypePhysicalVariation);
    }

    public VectorizedRowBatch createVectorizedRowBatch() {
        int i;
        int nonScratchColumnCount = this.rowColumnTypeInfos.length;
        int totalColumnCount = nonScratchColumnCount + this.scratchColumnTypeNames.length;
        VectorizedRowBatch result = new VectorizedRowBatch(totalColumnCount);
        if (this.dataColumnNums == null) {
            for (i = 0; i < nonScratchColumnCount; ++i) {
                result.cols[i] = this.createColumnVectorFromRowColumnTypeInfos(i);
            }
        } else {
            for (i = 0; i < this.dataColumnNums.length; ++i) {
                int columnNum = this.dataColumnNums[i];
                Preconditions.checkState(columnNum < nonScratchColumnCount);
                result.cols[columnNum] = this.createColumnVectorFromRowColumnTypeInfos(columnNum);
            }
            int partitionEndColumnNum = this.dataColumnCount + this.partitionColumnCount;
            for (int partitionColumnNum = this.dataColumnCount; partitionColumnNum < partitionEndColumnNum; ++partitionColumnNum) {
                result.cols[partitionColumnNum] = VectorizedBatchUtil.createColumnVector(this.rowColumnTypeInfos[partitionColumnNum]);
            }
            int virtualEndColumnNum = partitionEndColumnNum + this.virtualColumnCount;
            for (int virtualColumnNum = partitionEndColumnNum; virtualColumnNum < virtualEndColumnNum; ++virtualColumnNum) {
                String virtualColumnName = this.rowColumnNames[virtualColumnNum];
                if (!this.isVirtualColumnNeeded(virtualColumnName)) continue;
                result.cols[virtualColumnNum] = VectorizedBatchUtil.createColumnVector(this.rowColumnTypeInfos[virtualColumnNum]);
            }
        }
        for (i = 0; i < this.scratchColumnTypeNames.length; ++i) {
            String typeName = this.scratchColumnTypeNames[i];
            DataTypePhysicalVariation dataTypePhysicalVariation = this.scratchDataTypePhysicalVariations[i];
            result.cols[nonScratchColumnCount + i] = VectorizedBatchUtil.createColumnVector(typeName, dataTypePhysicalVariation);
        }
        result.setPartitionInfo(this.dataColumnCount, this.partitionColumnCount);
        result.reset();
        return result;
    }

    public void addPartitionColsToBatch(VectorizedRowBatch batch, Object[] partitionValues) {
        this.addPartitionColsToBatch(batch.cols, partitionValues);
    }

    public void addPartitionColsToBatch(ColumnVector[] cols, Object[] partitionValues) {
        if (partitionValues != null) {
            block16: for (int i = 0; i < this.partitionColumnCount; ++i) {
                Object value = partitionValues[i];
                int colIndex = this.dataColumnCount + i;
                String partitionColumnName = this.rowColumnNames[colIndex];
                PrimitiveTypeInfo primitiveTypeInfo = (PrimitiveTypeInfo)this.rowColumnTypeInfos[colIndex];
                switch (primitiveTypeInfo.getPrimitiveCategory()) {
                    case BOOLEAN: {
                        ColumnVector lcv = (LongColumnVector)cols[colIndex];
                        if (value == null) {
                            ((LongColumnVector)lcv).noNulls = false;
                            ((LongColumnVector)lcv).isNull[0] = true;
                            ((LongColumnVector)lcv).isRepeating = true;
                            continue block16;
                        }
                        ((LongColumnVector)lcv).fill((Boolean)value == true ? 1L : 0L);
                        continue block16;
                    }
                    case BYTE: {
                        ColumnVector lcv = (LongColumnVector)cols[colIndex];
                        if (value == null) {
                            ((LongColumnVector)lcv).noNulls = false;
                            ((LongColumnVector)lcv).isNull[0] = true;
                            ((LongColumnVector)lcv).isRepeating = true;
                            continue block16;
                        }
                        ((LongColumnVector)lcv).fill(((Byte)value).byteValue());
                        continue block16;
                    }
                    case SHORT: {
                        ColumnVector lcv = (LongColumnVector)cols[colIndex];
                        if (value == null) {
                            ((LongColumnVector)lcv).noNulls = false;
                            ((LongColumnVector)lcv).isNull[0] = true;
                            ((LongColumnVector)lcv).isRepeating = true;
                            continue block16;
                        }
                        ((LongColumnVector)lcv).fill(((Short)value).shortValue());
                        continue block16;
                    }
                    case INT: {
                        ColumnVector lcv = (LongColumnVector)cols[colIndex];
                        if (value == null) {
                            ((LongColumnVector)lcv).noNulls = false;
                            ((LongColumnVector)lcv).isNull[0] = true;
                            ((LongColumnVector)lcv).isRepeating = true;
                            continue block16;
                        }
                        ((LongColumnVector)lcv).fill(((Integer)value).intValue());
                        continue block16;
                    }
                    case LONG: {
                        ColumnVector lcv = (LongColumnVector)cols[colIndex];
                        if (value == null) {
                            ((LongColumnVector)lcv).noNulls = false;
                            ((LongColumnVector)lcv).isNull[0] = true;
                            ((LongColumnVector)lcv).isRepeating = true;
                            continue block16;
                        }
                        ((LongColumnVector)lcv).fill((Long)value);
                        continue block16;
                    }
                    case DATE: {
                        ColumnVector lcv = (LongColumnVector)cols[colIndex];
                        if (value == null) {
                            ((LongColumnVector)lcv).noNulls = false;
                            ((LongColumnVector)lcv).isNull[0] = true;
                            ((LongColumnVector)lcv).isRepeating = true;
                            continue block16;
                        }
                        ((LongColumnVector)lcv).fill(DateWritableV2.dateToDays((Date)value));
                        continue block16;
                    }
                    case TIMESTAMP: {
                        ColumnVector lcv = (TimestampColumnVector)cols[colIndex];
                        if (value == null) {
                            ((TimestampColumnVector)lcv).noNulls = false;
                            ((TimestampColumnVector)lcv).isNull[0] = true;
                            ((TimestampColumnVector)lcv).isRepeating = true;
                            continue block16;
                        }
                        ((TimestampColumnVector)lcv).fill(((Timestamp)value).toSqlTimestamp());
                        continue block16;
                    }
                    case INTERVAL_YEAR_MONTH: {
                        ColumnVector lcv = (LongColumnVector)cols[colIndex];
                        if (value == null) {
                            ((LongColumnVector)lcv).noNulls = false;
                            ((LongColumnVector)lcv).isNull[0] = true;
                            ((LongColumnVector)lcv).isRepeating = true;
                        } else {
                            ((LongColumnVector)lcv).fill(((HiveIntervalYearMonth)value).getTotalMonths());
                        }
                    }
                    case INTERVAL_DAY_TIME: {
                        IntervalDayTimeColumnVector icv = (IntervalDayTimeColumnVector)cols[colIndex];
                        if (value == null) {
                            icv.noNulls = false;
                            icv.isNull[0] = true;
                            icv.isRepeating = true;
                        } else {
                            icv.fill((HiveIntervalDayTime)value);
                        }
                    }
                    case FLOAT: {
                        DoubleColumnVector dcv = (DoubleColumnVector)cols[colIndex];
                        if (value == null) {
                            dcv.noNulls = false;
                            dcv.isNull[0] = true;
                            dcv.isRepeating = true;
                            continue block16;
                        }
                        dcv.fill(((Float)value).floatValue());
                        continue block16;
                    }
                    case DOUBLE: {
                        DoubleColumnVector dcv = (DoubleColumnVector)cols[colIndex];
                        if (value == null) {
                            dcv.noNulls = false;
                            dcv.isNull[0] = true;
                            dcv.isRepeating = true;
                            continue block16;
                        }
                        dcv.fill((Double)value);
                        continue block16;
                    }
                    case DECIMAL: {
                        DecimalColumnVector dv = (DecimalColumnVector)cols[colIndex];
                        if (value == null) {
                            dv.noNulls = false;
                            dv.isNull[0] = true;
                            dv.isRepeating = true;
                            continue block16;
                        }
                        dv.fill((HiveDecimal)value);
                        continue block16;
                    }
                    case BINARY: {
                        BytesColumnVector bcv = (BytesColumnVector)cols[colIndex];
                        byte[] bytes = (byte[])value;
                        if (bytes == null) {
                            bcv.noNulls = false;
                            bcv.isNull[0] = true;
                            bcv.isRepeating = true;
                            continue block16;
                        }
                        bcv.fill(bytes);
                        continue block16;
                    }
                    case STRING: 
                    case CHAR: 
                    case VARCHAR: {
                        BytesColumnVector bcv = (BytesColumnVector)cols[colIndex];
                        String sVal = value.toString();
                        if (sVal == null) {
                            bcv.noNulls = false;
                            bcv.isNull[0] = true;
                            bcv.isRepeating = true;
                            continue block16;
                        }
                        bcv.fill(sVal.getBytes());
                        continue block16;
                    }
                    default: {
                        throw new RuntimeException("Unable to recognize the partition type " + (Object)((Object)primitiveTypeInfo.getPrimitiveCategory()) + " for column " + partitionColumnName);
                    }
                }
            }
        }
    }

    public final boolean isPartitionCol(int colNum) {
        return colNum >= this.dataColumnCount && colNum < this.rowColumnTypeInfos.length;
    }
}

