/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez;

import hive.com.google.common.base.Preconditions;
import hive.com.google.common.collect.ArrayListMultimap;
import hive.com.google.common.collect.HashMultimap;
import hive.com.google.common.collect.LinkedListMultimap;
import hive.com.google.common.collect.Lists;
import hive.com.google.common.collect.Maps;
import hive.com.google.common.collect.Multimap;
import hive.com.google.protobuf.ByteString;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.tez.CustomEdgeConfiguration;
import org.apache.hadoop.hive.ql.exec.tez.CustomPartitionEdge;
import org.apache.hadoop.hive.ql.exec.tez.CustomVertexConfiguration;
import org.apache.hadoop.hive.ql.exec.tez.DataInputByteBuffer;
import org.apache.hadoop.hive.ql.exec.tez.SplitGrouper;
import org.apache.hadoop.hive.ql.exec.tez.Utils;
import org.apache.hadoop.hive.ql.plan.TezWork;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.serializer.SerializationFactory;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.split.SplitLocationProvider;
import org.apache.hadoop.mapred.split.TezGroupedSplit;
import org.apache.tez.common.TezUtils;
import org.apache.tez.dag.api.EdgeManagerPluginDescriptor;
import org.apache.tez.dag.api.EdgeProperty;
import org.apache.tez.dag.api.InputDescriptor;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.dag.api.VertexLocationHint;
import org.apache.tez.dag.api.VertexManagerPlugin;
import org.apache.tez.dag.api.VertexManagerPluginContext;
import org.apache.tez.mapreduce.hadoop.MRInputHelpers;
import org.apache.tez.mapreduce.protos.MRRuntimeProtos;
import org.apache.tez.runtime.api.Event;
import org.apache.tez.runtime.api.InputSpecUpdate;
import org.apache.tez.runtime.api.events.CustomProcessorEvent;
import org.apache.tez.runtime.api.events.InputConfigureVertexTasksEvent;
import org.apache.tez.runtime.api.events.InputDataInformationEvent;
import org.apache.tez.runtime.api.events.InputUpdatePayloadEvent;
import org.apache.tez.runtime.api.events.VertexManagerEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomPartitionVertex
extends VertexManagerPlugin {
    private static final Logger LOG = LoggerFactory.getLogger((String)CustomPartitionVertex.class.getName());
    VertexManagerPluginContext context;
    private InputConfigureVertexTasksEvent configureVertexTaskEvent;
    private int numBuckets = -1;
    private Configuration conf = null;
    private final SplitGrouper grouper = new SplitGrouper();
    private int taskCount = 0;
    private TezWork.VertexType vertexType;
    private String mainWorkName;
    private final Multimap<Integer, Integer> bucketToTaskMap = HashMultimap.create();
    private final Map<String, Multimap<Integer, InputSplit>> inputToGroupedSplitMap = new HashMap<String, Multimap<Integer, InputSplit>>();
    private int numInputsAffectingRootInputSpecUpdate = 1;
    private int numInputsSeenSoFar = 0;
    private final Map<String, EdgeManagerPluginDescriptor> emMap = Maps.newHashMap();
    private final List<InputSplit> finalSplits = Lists.newLinkedList();
    private final Map<String, InputSpecUpdate> inputNameInputSpecMap = new HashMap<String, InputSpecUpdate>();
    private Map<String, Integer> inputToBucketMap;

    public CustomPartitionVertex(VertexManagerPluginContext context) {
        super(context);
    }

    public void initialize() {
        this.context = this.getContext();
        ByteBuffer payload = this.context.getUserPayload().getPayload();
        CustomVertexConfiguration vertexConf = new CustomVertexConfiguration();
        DataInputByteBuffer dibb = new DataInputByteBuffer();
        dibb.reset(payload);
        try {
            vertexConf.readFields(dibb);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.numBuckets = vertexConf.getNumBuckets();
        this.mainWorkName = vertexConf.getInputName();
        this.vertexType = vertexConf.getVertexType();
        this.numInputsAffectingRootInputSpecUpdate = vertexConf.getNumInputs();
        this.inputToBucketMap = vertexConf.getInputToBucketMap();
    }

    public void onVertexStarted(Map<String, List<Integer>> completions) {
        int numTasks = this.context.getVertexNumTasks(this.context.getVertexName());
        ArrayList<VertexManagerPluginContext.TaskWithLocationHint> scheduledTasks = new ArrayList<VertexManagerPluginContext.TaskWithLocationHint>(numTasks);
        for (int i = 0; i < numTasks; ++i) {
            scheduledTasks.add(new VertexManagerPluginContext.TaskWithLocationHint(new Integer(i), null));
        }
        this.context.scheduleVertexTasks(scheduledTasks);
    }

    public void onSourceTaskCompleted(String srcVertexName, Integer attemptId) {
    }

    public void onVertexManagerEventReceived(VertexManagerEvent vmEvent) {
    }

    public void onRootVertexInitialized(String inputName, InputDescriptor inputDescriptor, List<Event> events) {
        ++this.numInputsSeenSoFar;
        LOG.info("On root vertex initialized " + inputName);
        try {
            MRRuntimeProtos.MRInputUserPayloadProto protoPayload = MRInputHelpers.parseMRInputPayload((UserPayload)inputDescriptor.getUserPayload());
            this.conf = TezUtils.createConfFromByteString((ByteString)protoPayload.getConfigurationBytes());
            MRRuntimeProtos.MRInputUserPayloadProto updatedPayload = MRRuntimeProtos.MRInputUserPayloadProto.newBuilder((MRRuntimeProtos.MRInputUserPayloadProto)protoPayload).setGroupingEnabled(true).build();
            inputDescriptor.setUserPayload(UserPayload.create((ByteBuffer)updatedPayload.toByteString().asReadOnlyByteBuffer()));
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        boolean dataInformationEventSeen = false;
        TreeMap<String, Set<FileSplit>> pathFileSplitsMap = new TreeMap<String, Set<FileSplit>>();
        for (Event event : events) {
            FileSplit fileSplit;
            if (event instanceof InputConfigureVertexTasksEvent) {
                InputConfigureVertexTasksEvent cEvent;
                LOG.info("Got a input configure vertex event for input: " + inputName);
                Preconditions.checkState(!dataInformationEventSeen);
                this.configureVertexTaskEvent = cEvent = (InputConfigureVertexTasksEvent)event;
                LOG.info("Configure task for input name: " + inputName + " num tasks: " + this.configureVertexTaskEvent.getNumTasks());
            }
            if (event instanceof InputUpdatePayloadEvent) {
                Preconditions.checkState(false);
                continue;
            }
            if (!(event instanceof InputDataInformationEvent)) continue;
            dataInformationEventSeen = true;
            InputDataInformationEvent diEvent = (InputDataInformationEvent)event;
            try {
                fileSplit = this.getFileSplitFromEvent(diEvent);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to get file split for event: " + diEvent, e);
            }
            TreeSet<InputSplit> fsList = (TreeSet<InputSplit>)pathFileSplitsMap.get(Utilities.getBucketFileNameFromPathSubString(fileSplit.getPath().getName()));
            if (fsList == null) {
                fsList = new TreeSet<InputSplit>(new PathComparatorForSplit());
                pathFileSplitsMap.put(Utilities.getBucketFileNameFromPathSubString(fileSplit.getPath().getName()), fsList);
            }
            fsList.add((InputSplit)fileSplit);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Path file splits map for input name: " + inputName + " is " + pathFileSplitsMap);
        }
        Multimap<Integer, InputSplit> bucketToInitialSplitMap = this.getBucketSplitMapForPath(inputName, pathFileSplitsMap);
        try {
            int totalResource = this.context.getTotalAvailableResource().getMemory();
            int taskResource = this.context.getVertexTaskResource().getMemory();
            float waves = this.conf.getFloat("tez.grouping.split-waves", 1.7f);
            int availableSlots = totalResource / taskResource;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Grouping splits. " + availableSlots + " available slots, " + waves + " waves. Bucket initial splits map: " + bucketToInitialSplitMap);
            }
            JobConf jobConf = new JobConf(this.conf);
            ShimLoader.getHadoopShims().getMergedCredentials(jobConf);
            HashMultimap<Integer, InputSplit> bucketToGroupedSplitMap = HashMultimap.create();
            boolean secondLevelGroupingDone = false;
            if (this.mainWorkName.isEmpty() || inputName.compareTo(this.mainWorkName) == 0) {
                SplitLocationProvider splitLocationProvider = Utils.getSplitLocationProvider(this.conf, LOG);
                for (Integer key : bucketToInitialSplitMap.keySet()) {
                    InputSplit[] inputSplitArray = bucketToInitialSplitMap.get(key).toArray(new InputSplit[0]);
                    Multimap<Integer, InputSplit> groupedSplit = this.grouper.generateGroupedSplits(jobConf, this.conf, inputSplitArray, waves, availableSlots, inputName, this.mainWorkName.isEmpty(), splitLocationProvider);
                    if (!this.mainWorkName.isEmpty()) {
                        HashMultimap<Integer, InputSplit> singleBucketToGroupedSplit = HashMultimap.create();
                        singleBucketToGroupedSplit.putAll(key, groupedSplit.values());
                        groupedSplit = this.grouper.group((Configuration)jobConf, singleBucketToGroupedSplit, availableSlots, HiveConf.getFloatVar(this.conf, HiveConf.ConfVars.TEZ_SMB_NUMBER_WAVES), null);
                        secondLevelGroupingDone = true;
                    }
                    bucketToGroupedSplitMap.putAll(key, groupedSplit.values());
                }
                this.processAllEvents(inputName, bucketToGroupedSplitMap, secondLevelGroupingDone);
            } else {
                SplitLocationProvider splitLocationProvider = Utils.getSplitLocationProvider(this.conf, LOG);
                for (Integer key : bucketToInitialSplitMap.keySet()) {
                    InputSplit[] inputSplitArray = bucketToInitialSplitMap.get(key).toArray(new InputSplit[0]);
                    Multimap<Integer, InputSplit> groupedSplit = this.grouper.generateGroupedSplits(jobConf, this.conf, inputSplitArray, waves, availableSlots, inputName, false, splitLocationProvider);
                    bucketToGroupedSplitMap.putAll(key, groupedSplit.values());
                }
                LOG.info("This is the side work - multi-mr work.");
                this.processAllSideEventsSetParallelism(inputName, bucketToGroupedSplitMap);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void processAllSideEventsSetParallelism(String inputName, Multimap<Integer, InputSplit> bucketToGroupedSplitMap) throws IOException {
        LOG.info("Processing events for input " + inputName);
        if (this.inputNameInputSpecMap.get(this.mainWorkName) == null) {
            LOG.info("We don't have a routing table yet. Will need to wait for the main input " + this.mainWorkName + " initialization");
            this.inputToGroupedSplitMap.put(inputName, bucketToGroupedSplitMap);
            return;
        }
        this.processAllSideEvents(inputName, bucketToGroupedSplitMap);
        this.setVertexParallelismAndRootInputSpec(this.inputNameInputSpecMap);
    }

    private void processAllSideEvents(String inputName, Multimap<Integer, InputSplit> bucketToGroupedSplitMap) throws IOException {
        ArrayList<InputDataInformationEvent> taskEvents = new ArrayList<InputDataInformationEvent>();
        LOG.info("We have a routing table and we are going to set the destination tasks for the multi mr inputs. " + this.bucketToTaskMap);
        Object[] numSplitsForTask = new Integer[this.taskCount];
        Arrays.fill(numSplitsForTask, (Object)0);
        LinkedListMultimap<Integer, ByteBuffer> bucketToSerializedSplitMap = LinkedListMultimap.create();
        for (Map.Entry<Integer, Collection<InputSplit>> entry : bucketToGroupedSplitMap.asMap().entrySet()) {
            for (InputSplit split : entry.getValue()) {
                MRRuntimeProtos.MRSplitProto serializedSplit = MRInputHelpers.createSplitProto((InputSplit)split);
                ByteBuffer bs = serializedSplit.toByteString().asReadOnlyByteBuffer();
                bucketToSerializedSplitMap.put(entry.getKey(), bs);
            }
        }
        for (Map.Entry<Integer, Collection<Object>> entry : bucketToSerializedSplitMap.asMap().entrySet()) {
            Collection<Integer> destTasks = this.bucketToTaskMap.get(entry.getKey());
            if (destTasks == null || destTasks.isEmpty()) continue;
            for (Integer task : destTasks) {
                int count = 0;
                for (ByteBuffer byteBuffer : entry.getValue()) {
                    InputDataInformationEvent diEvent = InputDataInformationEvent.createWithSerializedPayload((int)(++count), (ByteBuffer)byteBuffer);
                    diEvent.setTargetIndex(task.intValue());
                    taskEvents.add(diEvent);
                }
                numSplitsForTask[task.intValue()] = count;
            }
        }
        this.inputNameInputSpecMap.put(inputName, InputSpecUpdate.createPerTaskInputSpecUpdate(Arrays.asList(numSplitsForTask)));
        LOG.info("For input name: " + inputName + " task events size is " + taskEvents.size());
        this.context.addRootInputEvents(inputName, taskEvents);
    }

    /*
     * WARNING - void declaration
     */
    private void processAllEvents(String inputName, Multimap<Integer, InputSplit> bucketToGroupedSplitMap, boolean secondLevelGroupingDone) throws IOException {
        int totalInputsCount = 0;
        ArrayList<Integer> numSplitsForTask = new ArrayList<Integer>();
        for (Map.Entry<Integer, Collection<InputSplit>> entry : bucketToGroupedSplitMap.asMap().entrySet()) {
            int n = entry.getKey();
            Collection<InputSplit> initialSplits = entry.getValue();
            this.finalSplits.addAll(initialSplits);
            for (InputSplit inputSplit : initialSplits) {
                this.bucketToTaskMap.put(n, this.taskCount);
                if (secondLevelGroupingDone) {
                    TezGroupedSplit groupedSplit = (TezGroupedSplit)inputSplit;
                    numSplitsForTask.add(groupedSplit.getGroupedSplits().size());
                    totalInputsCount += groupedSplit.getGroupedSplits().size();
                } else {
                    numSplitsForTask.add(1);
                    ++totalInputsCount;
                }
                ++this.taskCount;
            }
        }
        this.inputNameInputSpecMap.put(inputName, InputSpecUpdate.createPerTaskInputSpecUpdate(numSplitsForTask));
        EdgeManagerPluginDescriptor hiveEdgeManagerDesc = null;
        if (this.vertexType == TezWork.VertexType.MULTI_INPUT_INITIALIZED_EDGES || this.vertexType == TezWork.VertexType.INITIALIZED_EDGES) {
            hiveEdgeManagerDesc = EdgeManagerPluginDescriptor.create((String)CustomPartitionEdge.class.getName());
            UserPayload payload = this.getBytePayload(this.bucketToTaskMap);
            hiveEdgeManagerDesc.setUserPayload(payload);
        }
        for (Map.Entry entry : this.context.getInputVertexEdgeProperties().entrySet()) {
            if (((EdgeProperty)entry.getValue()).getDataMovementType() != EdgeProperty.DataMovementType.CUSTOM || !((EdgeProperty)entry.getValue()).getEdgeManagerDescriptor().getClassName().equals(CustomPartitionEdge.class.getName())) continue;
            this.emMap.put((String)entry.getKey(), hiveEdgeManagerDesc);
        }
        LOG.info("Task count is " + this.taskCount + " for input name: " + inputName);
        ArrayList<InputDataInformationEvent> taskEvents = Lists.newArrayListWithCapacity(totalInputsCount);
        boolean bl = false;
        for (InputSplit inputSplit : this.finalSplits) {
            void var8_11;
            if (secondLevelGroupingDone) {
                TezGroupedSplit tezGroupedSplit = (TezGroupedSplit)inputSplit;
                for (InputSplit subSplit : tezGroupedSplit.getGroupedSplits()) {
                    if (!(subSplit instanceof TezGroupedSplit)) {
                        throw new IOException("Unexpected split type found: " + subSplit.getClass().getCanonicalName());
                    }
                    MRRuntimeProtos.MRSplitProto serializedSplit = MRInputHelpers.createSplitProto((InputSplit)subSplit);
                    InputDataInformationEvent diEvent = InputDataInformationEvent.createWithSerializedPayload((int)var8_11, (ByteBuffer)serializedSplit.toByteString().asReadOnlyByteBuffer());
                    diEvent.setTargetIndex((int)var8_11);
                    taskEvents.add(diEvent);
                }
            } else {
                MRRuntimeProtos.MRSplitProto serializedSplit = MRInputHelpers.createSplitProto((InputSplit)inputSplit);
                InputDataInformationEvent diEvent = InputDataInformationEvent.createWithSerializedPayload((int)var8_11, (ByteBuffer)serializedSplit.toByteString().asReadOnlyByteBuffer());
                diEvent.setTargetIndex((int)var8_11);
                taskEvents.add(diEvent);
            }
            ++var8_11;
        }
        LOG.info("For input name: " + inputName + " task events size is " + taskEvents.size());
        this.context.addRootInputEvents(inputName, taskEvents);
        if (!this.inputToGroupedSplitMap.isEmpty()) {
            for (Map.Entry entry : this.inputToGroupedSplitMap.entrySet()) {
                this.processAllSideEvents((String)entry.getKey(), (Multimap)entry.getValue());
            }
            this.setVertexParallelismAndRootInputSpec(this.inputNameInputSpecMap);
            this.inputToGroupedSplitMap.clear();
        }
        if (this.numInputsAffectingRootInputSpecUpdate == 1) {
            this.setVertexParallelismAndRootInputSpec(this.inputNameInputSpecMap);
            this.sendBucketIdsToProcessor();
        }
    }

    private void sendBucketIdsToProcessor() {
        for (Map.Entry<Integer, Collection<Integer>> entry : this.bucketToTaskMap.asMap().entrySet()) {
            int bucketNum = entry.getKey();
            for (Integer taskId : entry.getValue()) {
                ByteBuffer buffer = ByteBuffer.allocate(8);
                buffer.putInt(this.numBuckets);
                buffer.putInt(bucketNum);
                buffer.flip();
                CustomProcessorEvent cpEvent = CustomProcessorEvent.create((ByteBuffer)buffer);
                this.context.sendEventToProcessor(Collections.singletonList(cpEvent), taskId.intValue());
            }
        }
    }

    private void setVertexParallelismAndRootInputSpec(Map<String, InputSpecUpdate> rootInputSpecUpdate) throws IOException {
        if (this.numInputsAffectingRootInputSpecUpdate != this.numInputsSeenSoFar) {
            return;
        }
        LOG.info("Setting vertex parallelism since we have seen all inputs.");
        boolean generateConsistentSplits = HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.HIVE_TEZ_GENERATE_CONSISTENT_SPLITS);
        LOG.info("GenerateConsistenSplitsInHive=" + generateConsistentSplits);
        this.context.setVertexParallelism(this.taskCount, VertexLocationHint.create(this.grouper.createTaskLocationHints(this.finalSplits.toArray(new InputSplit[this.finalSplits.size()]), generateConsistentSplits)), this.emMap, rootInputSpecUpdate);
        this.finalSplits.clear();
    }

    UserPayload getBytePayload(Multimap<Integer, Integer> routingTable) throws IOException {
        CustomEdgeConfiguration edgeConf = new CustomEdgeConfiguration(this.numBuckets, routingTable);
        DataOutputBuffer dob = new DataOutputBuffer();
        edgeConf.write((DataOutput)dob);
        byte[] serialized = dob.getData();
        return UserPayload.create((ByteBuffer)ByteBuffer.wrap(serialized));
    }

    private FileSplit getFileSplitFromEvent(InputDataInformationEvent event) throws IOException {
        InputSplit inputSplit = null;
        if (event.getDeserializedUserPayload() != null) {
            inputSplit = (InputSplit)event.getDeserializedUserPayload();
        } else {
            MRRuntimeProtos.MRSplitProto splitProto = MRRuntimeProtos.MRSplitProto.parseFrom((ByteString)ByteString.copyFrom(event.getUserPayload()));
            SerializationFactory serializationFactory = new SerializationFactory(new Configuration());
            inputSplit = MRInputHelpers.createOldFormatSplitFromUserPayload((MRRuntimeProtos.MRSplitProto)splitProto, (SerializationFactory)serializationFactory);
        }
        if (!(inputSplit instanceof FileSplit)) {
            throw new UnsupportedOperationException("Cannot handle splits other than FileSplit for the moment. Current input split type: " + inputSplit.getClass().getSimpleName());
        }
        return (FileSplit)inputSplit;
    }

    /*
     * WARNING - void declaration
     */
    private Multimap<Integer, InputSplit> getBucketSplitMapForPath(String inputName, Map<String, Set<FileSplit>> pathFileSplitsMap) {
        ArrayListMultimap<Integer, InputSplit> bucketToInitialSplitMap;
        block11: {
            void var8_17;
            int inputNumBuckets;
            HashMap<Integer, Integer> bucketIds;
            block12: {
                int bucketId;
                bucketToInitialSplitMap = ArrayListMultimap.create();
                boolean fallback = false;
                bucketIds = new HashMap<Integer, Integer>();
                for (Map.Entry<String, Set<FileSplit>> entry : pathFileSplitsMap.entrySet()) {
                    String string = Utilities.getBucketFileNameFromPathSubString(entry.getKey());
                    bucketId = Utilities.getBucketIdFromFile(string);
                    if (bucketId == -1) {
                        fallback = true;
                        LOG.info("Fallback to using older sort based logic to assign buckets to splits.");
                        bucketIds.clear();
                        break;
                    }
                    bucketIds.put(bucketId %= this.numBuckets, bucketId);
                    for (FileSplit fsplit : (Set)entry.getValue()) {
                        bucketToInitialSplitMap.put(bucketId, (InputSplit)fsplit);
                    }
                }
                int bucketNum = 0;
                if (fallback) {
                    for (Map.Entry entry : pathFileSplitsMap.entrySet()) {
                        bucketId = bucketNum % this.numBuckets;
                        for (FileSplit fsplit : (Set)entry.getValue()) {
                            bucketToInitialSplitMap.put(bucketId, (InputSplit)fsplit);
                        }
                        ++bucketNum;
                    }
                }
                if (this.numInputsAffectingRootInputSpecUpdate == 1) break block11;
                if (!fallback || bucketNum >= this.numBuckets) break block12;
                int loopedBucketId = 0;
                while (bucketNum < this.numBuckets) {
                    for (InputSplit fsplit : bucketToInitialSplitMap.get(loopedBucketId)) {
                        bucketToInitialSplitMap.put(bucketNum, fsplit);
                    }
                    ++loopedBucketId;
                    ++bucketNum;
                }
                break block11;
            }
            if (!this.inputToBucketMap.containsKey(inputName) || (inputNumBuckets = this.inputToBucketMap.get(inputName).intValue()) >= this.numBuckets) break block11;
            boolean bl = true;
            while (var8_17 < this.numBuckets / inputNumBuckets) {
                void bucketIdBase = var8_17 * inputNumBuckets;
                for (Integer bucketId : bucketIds.keySet()) {
                    for (InputSplit fsplit : bucketToInitialSplitMap.get(bucketId)) {
                        bucketToInitialSplitMap.put((int)(bucketIdBase + bucketId), fsplit);
                    }
                }
                ++var8_17;
            }
        }
        return bucketToInitialSplitMap;
    }

    public class PathComparatorForSplit
    implements Comparator<InputSplit> {
        @Override
        public int compare(InputSplit inp1, InputSplit inp2) {
            FileSplit fs1 = (FileSplit)inp1;
            FileSplit fs2 = (FileSplit)inp2;
            int retval = fs1.getPath().compareTo((Object)fs2.getPath());
            if (retval != 0) {
                return retval;
            }
            if (fs1.getStart() != fs2.getStart()) {
                return (int)(fs1.getStart() - fs2.getStart());
            }
            return 0;
        }
    }
}

