/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.impl;

import hive.com.google.protobuf.RpcController;
import hive.com.google.protobuf.ServiceException;
import java.io.IOException;
import java.net.InetSocketAddress;
import javax.annotation.Nullable;
import javax.net.SocketFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.llap.daemon.rpc.LlapDaemonProtocolProtos;
import org.apache.hadoop.hive.llap.protocol.LlapManagementProtocolPB;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ipc.ProtocolProxy;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.UserGroupInformation;

public class LlapManagementProtocolClientImpl
implements LlapManagementProtocolPB {
    private final Configuration conf;
    private final InetSocketAddress serverAddr;
    private final RetryPolicy retryPolicy;
    private final SocketFactory socketFactory;
    LlapManagementProtocolPB proxy;

    public LlapManagementProtocolClientImpl(Configuration conf, String hostname, int port, @Nullable RetryPolicy retryPolicy, @Nullable SocketFactory socketFactory) {
        this.conf = conf;
        this.serverAddr = NetUtils.createSocketAddr((String)hostname, (int)port);
        this.retryPolicy = retryPolicy;
        this.socketFactory = socketFactory == null ? NetUtils.getDefaultSocketFactory((Configuration)conf) : socketFactory;
    }

    public LlapManagementProtocolPB getProxy() throws IOException {
        if (this.proxy == null) {
            this.proxy = this.createProxy();
        }
        return this.proxy;
    }

    public LlapManagementProtocolPB createProxy() throws IOException {
        RPC.setProtocolEngine((Configuration)this.conf, LlapManagementProtocolPB.class, ProtobufRpcEngine.class);
        ProtocolProxy proxy = RPC.getProtocolProxy(LlapManagementProtocolPB.class, (long)0L, (InetSocketAddress)this.serverAddr, (UserGroupInformation)UserGroupInformation.getCurrentUser(), (Configuration)this.conf, (SocketFactory)this.socketFactory, (int)0, (RetryPolicy)this.retryPolicy);
        return (LlapManagementProtocolPB)proxy.getProxy();
    }

    @Override
    public LlapDaemonProtocolProtos.GetTokenResponseProto getDelegationToken(RpcController controller, LlapDaemonProtocolProtos.GetTokenRequestProto request) throws ServiceException {
        try {
            return this.getProxy().getDelegationToken(null, request);
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public LlapDaemonProtocolProtos.PurgeCacheResponseProto purgeCache(RpcController controller, LlapDaemonProtocolProtos.PurgeCacheRequestProto request) throws ServiceException {
        try {
            return this.getProxy().purgeCache(null, request);
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
    }
}

