/*
 * Decompiled with CFR 0.152.
 */
package hive.shaded.parquet.org.codehaus.jackson.map.ser.std;

import hive.shaded.parquet.org.codehaus.jackson.JsonGenerationException;
import hive.shaded.parquet.org.codehaus.jackson.JsonGenerator;
import hive.shaded.parquet.org.codehaus.jackson.JsonNode;
import hive.shaded.parquet.org.codehaus.jackson.map.JsonMappingException;
import hive.shaded.parquet.org.codehaus.jackson.map.JsonSerializable;
import hive.shaded.parquet.org.codehaus.jackson.map.JsonSerializableWithType;
import hive.shaded.parquet.org.codehaus.jackson.map.ObjectMapper;
import hive.shaded.parquet.org.codehaus.jackson.map.SerializerProvider;
import hive.shaded.parquet.org.codehaus.jackson.map.TypeSerializer;
import hive.shaded.parquet.org.codehaus.jackson.map.annotate.JacksonStdImpl;
import hive.shaded.parquet.org.codehaus.jackson.map.ser.SerializerBase;
import hive.shaded.parquet.org.codehaus.jackson.map.type.TypeFactory;
import hive.shaded.parquet.org.codehaus.jackson.node.ObjectNode;
import hive.shaded.parquet.org.codehaus.jackson.schema.JsonSerializableSchema;
import java.io.IOException;
import java.lang.reflect.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JacksonStdImpl
public class SerializableSerializer
extends SerializerBase<JsonSerializable> {
    public static final SerializableSerializer instance = new SerializableSerializer();

    protected SerializableSerializer() {
        super(JsonSerializable.class);
    }

    @Override
    public void serialize(JsonSerializable value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
        value.serialize(jgen, provider);
    }

    @Override
    public final void serializeWithType(JsonSerializable value, JsonGenerator jgen, SerializerProvider provider, TypeSerializer typeSer) throws IOException, JsonGenerationException {
        if (value instanceof JsonSerializableWithType) {
            ((JsonSerializableWithType)value).serializeWithType(jgen, provider, typeSer);
        } else {
            this.serialize(value, jgen, provider);
        }
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) throws JsonMappingException {
        Class<?> rawClass;
        ObjectNode objectNode = this.createObjectNode();
        String schemaType = "any";
        String objectProperties = null;
        String itemDefinition = null;
        if (typeHint != null && (rawClass = TypeFactory.type(typeHint).getRawClass()).isAnnotationPresent(JsonSerializableSchema.class)) {
            JsonSerializableSchema schemaInfo = rawClass.getAnnotation(JsonSerializableSchema.class);
            schemaType = schemaInfo.schemaType();
            if (!"##irrelevant".equals(schemaInfo.schemaObjectPropertiesDefinition())) {
                objectProperties = schemaInfo.schemaObjectPropertiesDefinition();
            }
            if (!"##irrelevant".equals(schemaInfo.schemaItemDefinition())) {
                itemDefinition = schemaInfo.schemaItemDefinition();
            }
        }
        objectNode.put("type", schemaType);
        if (objectProperties != null) {
            try {
                objectNode.put("properties", new ObjectMapper().readValue(objectProperties, JsonNode.class));
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        if (itemDefinition != null) {
            try {
                objectNode.put("items", new ObjectMapper().readValue(itemDefinition, JsonNode.class));
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        return objectNode;
    }
}

