/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.parquet.io;

import hive.org.apache.parquet.column.ColumnDescriptor;
import hive.org.apache.parquet.io.ColumnIO;
import hive.org.apache.parquet.io.GroupColumnIO;
import hive.org.apache.parquet.schema.PrimitiveType;
import hive.org.apache.parquet.schema.Type;
import java.util.Arrays;
import java.util.List;

public class PrimitiveColumnIO
extends ColumnIO {
    private ColumnIO[] path;
    private ColumnDescriptor columnDescriptor;
    private final int id;

    PrimitiveColumnIO(Type type, GroupColumnIO parent, int index, int id) {
        super(type, parent, index);
        this.id = id;
    }

    @Override
    void setLevels(int r, int d, String[] fieldPath, int[] fieldIndexPath, List<ColumnIO> repetition, List<ColumnIO> path) {
        super.setLevels(r, d, fieldPath, fieldIndexPath, repetition, path);
        PrimitiveType type = this.getType().asPrimitiveType();
        this.columnDescriptor = new ColumnDescriptor(fieldPath, type.getPrimitiveTypeName(), type.getTypeLength(), this.getRepetitionLevel(), this.getDefinitionLevel());
        this.path = path.toArray(new ColumnIO[path.size()]);
    }

    @Override
    List<String[]> getColumnNames() {
        return Arrays.asList(new String[][]{this.getFieldPath()});
    }

    public ColumnDescriptor getColumnDescriptor() {
        return this.columnDescriptor;
    }

    public ColumnIO[] getPath() {
        return this.path;
    }

    public boolean isLast(int r) {
        return this.getLast(r) == this;
    }

    private PrimitiveColumnIO getLast(int r) {
        ColumnIO parent = this.getParent(r);
        PrimitiveColumnIO last = parent.getLast();
        return last;
    }

    @Override
    PrimitiveColumnIO getLast() {
        return this;
    }

    @Override
    PrimitiveColumnIO getFirst() {
        return this;
    }

    public boolean isFirst(int r) {
        return this.getFirst(r) == this;
    }

    private PrimitiveColumnIO getFirst(int r) {
        ColumnIO parent = this.getParent(r);
        return parent.getFirst();
    }

    public PrimitiveType.PrimitiveTypeName getPrimitive() {
        return this.getType().asPrimitiveType().getPrimitiveTypeName();
    }

    public int getId() {
        return this.id;
    }
}

