/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.parquet.hadoop.metadata;

import hive.org.apache.parquet.Preconditions;
import hive.org.apache.parquet.schema.MessageType;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;

public final class FileMetaData
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final MessageType schema;
    private final Map<String, String> keyValueMetaData;
    private final String createdBy;

    public FileMetaData(MessageType schema, Map<String, String> keyValueMetaData, String createdBy) {
        this.schema = Preconditions.checkNotNull(schema, "schema");
        this.keyValueMetaData = Collections.unmodifiableMap(Preconditions.checkNotNull(keyValueMetaData, "keyValueMetaData"));
        this.createdBy = createdBy;
    }

    public MessageType getSchema() {
        return this.schema;
    }

    public String toString() {
        return "FileMetaData{schema: " + this.schema + ", metadata: " + this.keyValueMetaData + "}";
    }

    public Map<String, String> getKeyValueMetaData() {
        return this.keyValueMetaData;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }
}

