/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.parquet.hadoop;

import hive.org.apache.parquet.CorruptDeltaByteArrays;
import hive.org.apache.parquet.column.Encoding;
import hive.org.apache.parquet.filter.UnboundRecordFilter;
import hive.org.apache.parquet.filter2.compat.FilterCompat;
import hive.org.apache.parquet.format.converter.ParquetMetadataConverter;
import hive.org.apache.parquet.hadoop.InternalParquetRecordReader;
import hive.org.apache.parquet.hadoop.ParquetFileReader;
import hive.org.apache.parquet.hadoop.ParquetInputFormat;
import hive.org.apache.parquet.hadoop.ParquetInputSplit;
import hive.org.apache.parquet.hadoop.api.ReadSupport;
import hive.org.apache.parquet.hadoop.metadata.BlockMetaData;
import hive.org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import hive.org.apache.parquet.hadoop.metadata.FileMetaData;
import hive.org.apache.parquet.hadoop.util.ContextUtil;
import hive.org.apache.parquet.hadoop.util.counters.BenchmarkCounter;
import hive.org.apache.parquet.io.ParquetDecodingException;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParquetRecordReader<T>
extends RecordReader<Void, T> {
    private static final Logger LOG = LoggerFactory.getLogger(ParquetRecordReader.class);
    private final InternalParquetRecordReader<T> internalReader;

    public ParquetRecordReader(ReadSupport<T> readSupport) {
        this(readSupport, FilterCompat.NOOP);
    }

    public ParquetRecordReader(ReadSupport<T> readSupport, FilterCompat.Filter filter) {
        this.internalReader = new InternalParquetRecordReader<T>(readSupport, filter);
    }

    @Deprecated
    public ParquetRecordReader(ReadSupport<T> readSupport, UnboundRecordFilter filter) {
        this(readSupport, FilterCompat.get(filter));
    }

    public void close() throws IOException {
        this.internalReader.close();
    }

    public Void getCurrentKey() throws IOException, InterruptedException {
        return null;
    }

    public T getCurrentValue() throws IOException, InterruptedException {
        return this.internalReader.getCurrentValue();
    }

    public float getProgress() throws IOException, InterruptedException {
        return this.internalReader.getProgress();
    }

    public void initialize(InputSplit inputSplit, TaskAttemptContext context) throws IOException, InterruptedException {
        if (ContextUtil.hasCounterMethod(context)) {
            BenchmarkCounter.initCounterFromContext(context);
        } else {
            LOG.error(String.format("Can not initialize counter because the class '%s' does not have a '.getCounterMethod'", context.getClass().getCanonicalName()));
        }
        this.initializeInternalReader(this.toParquetSplit(inputSplit), ContextUtil.getConfiguration((JobContext)context));
    }

    public void initialize(InputSplit inputSplit, Configuration configuration, Reporter reporter) throws IOException, InterruptedException {
        BenchmarkCounter.initCounterFromReporter(reporter, configuration);
        this.initializeInternalReader(this.toParquetSplit(inputSplit), configuration);
    }

    private void initializeInternalReader(ParquetInputSplit split, Configuration configuration) throws IOException {
        Path path = split.getPath();
        long[] rowGroupOffsets = split.getRowGroupOffsets();
        ParquetMetadataConverter.MetadataFilter metadataFilter = rowGroupOffsets != null ? ParquetMetadataConverter.offsets(rowGroupOffsets) : ParquetMetadataConverter.range(split.getStart(), split.getEnd());
        ParquetFileReader reader = ParquetFileReader.open(configuration, path, metadataFilter);
        if (rowGroupOffsets != null) {
            List<BlockMetaData> blocks = reader.getFooter().getBlocks();
            if (blocks.size() != rowGroupOffsets.length) {
                throw new IllegalStateException("All of the offsets in the split should be found in the file. expected: " + Arrays.toString(rowGroupOffsets) + " found: " + blocks);
            }
        } else {
            reader.filterRowGroups(ParquetInputFormat.getFilter(configuration));
        }
        if (!reader.getRowGroups().isEmpty()) {
            this.checkDeltaByteArrayProblem(reader.getFooter().getFileMetaData(), configuration, reader.getRowGroups().get(0));
        }
        this.internalReader.initialize(reader, configuration);
    }

    private void checkDeltaByteArrayProblem(FileMetaData meta, Configuration conf, BlockMetaData block) {
        if (conf.getBoolean("parquet.split.files", true)) {
            HashSet<Encoding> encodings = new HashSet<Encoding>();
            for (ColumnChunkMetaData column : block.getColumns()) {
                encodings.addAll(column.getEncodings());
            }
            for (Encoding encoding : encodings) {
                if (!CorruptDeltaByteArrays.requiresSequentialReads(meta.getCreatedBy(), encoding)) continue;
                throw new ParquetDecodingException("Cannot read data due to PARQUET-246: to read safely, set parquet.split.files to false");
            }
        }
    }

    public boolean nextKeyValue() throws IOException, InterruptedException {
        return this.internalReader.nextKeyValue();
    }

    private ParquetInputSplit toParquetSplit(InputSplit split) throws IOException {
        if (split instanceof ParquetInputSplit) {
            return (ParquetInputSplit)split;
        }
        if (split instanceof FileSplit) {
            return ParquetInputSplit.from((FileSplit)split);
        }
        if (split instanceof org.apache.hadoop.mapred.FileSplit) {
            return ParquetInputSplit.from((org.apache.hadoop.mapred.FileSplit)split);
        }
        throw new IllegalArgumentException("Invalid split (not a FileSplit or ParquetInputSplit): " + split);
    }
}

