/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.parquet.column.values.rle;

import hive.org.apache.parquet.bytes.BytesUtils;
import hive.org.apache.parquet.column.values.ValuesReader;
import hive.org.apache.parquet.column.values.rle.RunLengthBitPackingHybridDecoder;
import hive.org.apache.parquet.io.ParquetDecodingException;
import java.io.ByteArrayInputStream;
import java.io.IOException;

public class RunLengthBitPackingHybridValuesReader
extends ValuesReader {
    private final int bitWidth;
    private RunLengthBitPackingHybridDecoder decoder;
    private int nextOffset;

    public RunLengthBitPackingHybridValuesReader(int bitWidth) {
        this.bitWidth = bitWidth;
    }

    @Override
    public void initFromPage(int valueCountL, byte[] page, int offset) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(page, offset, page.length - offset);
        int length = BytesUtils.readIntLittleEndian(in);
        this.decoder = new RunLengthBitPackingHybridDecoder(this.bitWidth, in);
        this.nextOffset = offset + length + 4;
    }

    @Override
    public int getNextOffset() {
        return this.nextOffset;
    }

    @Override
    public int readInteger() {
        try {
            return this.decoder.readInt();
        }
        catch (IOException e) {
            throw new ParquetDecodingException(e);
        }
    }

    @Override
    public boolean readBoolean() {
        return this.readInteger() != 0;
    }

    @Override
    public void skip() {
        this.readInteger();
    }
}

