/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.parquet.column.values.plain;

import hive.org.apache.parquet.column.values.ValuesReader;
import hive.org.apache.parquet.column.values.bitpacking.ByteBitPackingValuesReader;
import hive.org.apache.parquet.column.values.bitpacking.Packer;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BooleanPlainValuesReader
extends ValuesReader {
    private static final Logger LOG = LoggerFactory.getLogger(BooleanPlainValuesReader.class);
    private ByteBitPackingValuesReader in = new ByteBitPackingValuesReader(1, Packer.LITTLE_ENDIAN);

    @Override
    public boolean readBoolean() {
        return this.in.readInteger() != 0;
    }

    @Override
    public void skip() {
        this.in.readInteger();
    }

    @Override
    public void initFromPage(int valueCount, byte[] in, int offset) throws IOException {
        LOG.debug("init from page at offset {} for length {}", (Object)offset, (Object)(in.length - offset));
        this.in.initFromPage(valueCount, in, offset);
    }

    @Override
    public int getNextOffset() {
        return this.in.getNextOffset();
    }
}

