/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.parquet.bytes;

import hive.org.apache.parquet.bytes.BytesInput;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class ConcatenatingByteArrayCollector
extends BytesInput {
    private final List<byte[]> slabs = new ArrayList<byte[]>();
    private long size = 0L;

    public void collect(BytesInput bytesInput) throws IOException {
        byte[] bytes = bytesInput.toByteArray();
        this.slabs.add(bytes);
        this.size += (long)bytes.length;
    }

    public void reset() {
        this.size = 0L;
        this.slabs.clear();
    }

    @Override
    public void writeAllTo(OutputStream out) throws IOException {
        for (byte[] slab : this.slabs) {
            out.write(slab);
        }
    }

    @Override
    public long size() {
        return this.size;
    }

    public String memUsageString(String prefix) {
        return String.format("%s %s %d slabs, %,d bytes", prefix, this.getClass().getSimpleName(), this.slabs.size(), this.size);
    }
}

