/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.avro.mapreduce;

import hive.org.apache.avro.Schema;
import hive.org.apache.avro.hadoop.io.AvroSequenceFile;
import hive.org.apache.avro.mapreduce.AvroJob;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.DefaultCodec;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.ReflectionUtils;

public class AvroSequenceFileOutputFormat<K, V>
extends FileOutputFormat<K, V> {
    private static final String CONF_COMPRESSION_TYPE = "mapred.output.compression.type";
    private static final SequenceFile.CompressionType DEFAULT_COMPRESSION_TYPE = SequenceFile.CompressionType.RECORD;

    public RecordWriter<K, V> getRecordWriter(TaskAttemptContext context) throws IOException, InterruptedException {
        Schema valueSchema;
        Configuration conf = context.getConfiguration();
        CompressionCodec codec = null;
        SequenceFile.CompressionType compressionType = SequenceFile.CompressionType.NONE;
        if (AvroSequenceFileOutputFormat.getCompressOutput((JobContext)context)) {
            compressionType = AvroSequenceFileOutputFormat.getOutputCompressionType(conf);
            Class codecClass = AvroSequenceFileOutputFormat.getOutputCompressorClass((JobContext)context, DefaultCodec.class);
            codec = (CompressionCodec)ReflectionUtils.newInstance((Class)codecClass, (Configuration)conf);
        }
        Path outputFile = this.getDefaultWorkFile(context, "");
        FileSystem fs = outputFile.getFileSystem(conf);
        AvroSequenceFile.Writer.Options options = new AvroSequenceFile.Writer.Options().withFileSystem(fs).withConfiguration(conf).withOutputPath(outputFile).withKeyClass(context.getOutputKeyClass()).withValueClass(context.getOutputValueClass()).withProgressable((Progressable)context).withCompressionType(compressionType).withCompressionCodec(codec);
        Schema keySchema = AvroJob.getOutputKeySchema(conf);
        if (null != keySchema) {
            options.withKeySchema(keySchema);
        }
        if (null != (valueSchema = AvroJob.getOutputValueSchema(conf))) {
            options.withValueSchema(valueSchema);
        }
        final SequenceFile.Writer out = AvroSequenceFile.createWriter(options);
        return new RecordWriter<K, V>(){

            public void write(K key, V value) throws IOException {
                out.append(key, value);
            }

            public void close(TaskAttemptContext context) throws IOException {
                out.close();
            }
        };
    }

    public static void setOutputCompressionType(Job job, SequenceFile.CompressionType compressionType) {
        AvroSequenceFileOutputFormat.setCompressOutput((Job)job, (boolean)true);
        job.getConfiguration().set(CONF_COMPRESSION_TYPE, compressionType.name());
    }

    public static SequenceFile.CompressionType getOutputCompressionType(Configuration conf) {
        String typeName = conf.get(CONF_COMPRESSION_TYPE, DEFAULT_COMPRESSION_TYPE.name());
        return SequenceFile.CompressionType.valueOf((String)typeName);
    }
}

