/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.avro.hadoop.io;

import hive.org.apache.avro.Schema;
import hive.org.apache.avro.io.BinaryEncoder;
import hive.org.apache.avro.io.DatumWriter;
import hive.org.apache.avro.io.EncoderFactory;
import hive.org.apache.avro.mapred.AvroWrapper;
import hive.org.apache.avro.reflect.ReflectDatumWriter;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.hadoop.io.serializer.Serializer;

public class AvroSerializer<T>
implements Serializer<AvroWrapper<T>> {
    private static final int AVRO_ENCODER_BLOCK_SIZE_BYTES = 512;
    private static EncoderFactory mEncoderFactory = new EncoderFactory().configureBlockSize(512);
    private final Schema mWriterSchema;
    private final DatumWriter<T> mAvroDatumWriter;
    private BinaryEncoder mAvroEncoder;
    private OutputStream mOutputStream;

    public AvroSerializer(Schema writerSchema) {
        if (null == writerSchema) {
            throw new IllegalArgumentException("Writer schema may not be null");
        }
        this.mWriterSchema = writerSchema;
        this.mAvroDatumWriter = new ReflectDatumWriter(writerSchema);
    }

    public AvroSerializer(Schema writerSchema, DatumWriter<T> datumWriter) {
        if (null == writerSchema) {
            throw new IllegalArgumentException("Writer schema may not be null");
        }
        this.mWriterSchema = writerSchema;
        this.mAvroDatumWriter = datumWriter;
    }

    public Schema getWriterSchema() {
        return this.mWriterSchema;
    }

    public void open(OutputStream outputStream) throws IOException {
        this.mOutputStream = outputStream;
        this.mAvroEncoder = mEncoderFactory.binaryEncoder(outputStream, this.mAvroEncoder);
    }

    public void serialize(AvroWrapper<T> avroWrapper) throws IOException {
        this.mAvroDatumWriter.write(avroWrapper.datum(), this.mAvroEncoder);
        this.mAvroEncoder.flush();
    }

    public void close() throws IOException {
        this.mOutputStream.close();
    }
}

