/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.teampolicies;

import com.dropbox.core.stone.UnionSerializer;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;

public enum SmartSyncPolicy {
    LOCAL,
    ON_DEMAND,
    OTHER;


    public static class Serializer
    extends UnionSerializer<SmartSyncPolicy> {
        public static final Serializer INSTANCE = new Serializer();

        @Override
        public void serialize(SmartSyncPolicy value, JsonGenerator g) throws IOException, JsonGenerationException {
            switch (value) {
                case LOCAL: {
                    g.writeString("local");
                    break;
                }
                case ON_DEMAND: {
                    g.writeString("on_demand");
                    break;
                }
                default: {
                    g.writeString("other");
                }
            }
        }

        @Override
        public SmartSyncPolicy deserialize(JsonParser p) throws IOException, JsonParseException {
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            SmartSyncPolicy value = "local".equals(tag) ? LOCAL : ("on_demand".equals(tag) ? ON_DEMAND : OTHER);
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }
}

