/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.server;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.Reader;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.adapter.jdbc.JdbcSchema;
import org.apache.calcite.avatica.AvaticaUtils;
import org.apache.calcite.jdbc.CalcitePrepare;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.jdbc.ContextSqlValidator;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.materialize.MaterializationKey;
import org.apache.calcite.materialize.MaterializationService;
import org.apache.calcite.model.JsonSchema;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.rel.RelRoot;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.RelDataTypeImpl;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.runtime.Resources;
import org.apache.calcite.schema.ColumnStrategy;
import org.apache.calcite.schema.Function;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaFactory;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.TranslatableTable;
import org.apache.calcite.schema.Wrapper;
import org.apache.calcite.schema.impl.AbstractSchema;
import org.apache.calcite.schema.impl.ViewTable;
import org.apache.calcite.schema.impl.ViewTableMacro;
import org.apache.calcite.server.DdlExecutor;
import org.apache.calcite.server.DdlExecutorImpl;
import org.apache.calcite.server.MaterializedViewTable;
import org.apache.calcite.server.MutableArrayTable;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.SqlWriterConfig;
import org.apache.calcite.sql.ddl.SqlAttributeDefinition;
import org.apache.calcite.sql.ddl.SqlColumnDeclaration;
import org.apache.calcite.sql.ddl.SqlCreateForeignSchema;
import org.apache.calcite.sql.ddl.SqlCreateFunction;
import org.apache.calcite.sql.ddl.SqlCreateMaterializedView;
import org.apache.calcite.sql.ddl.SqlCreateSchema;
import org.apache.calcite.sql.ddl.SqlCreateTable;
import org.apache.calcite.sql.ddl.SqlCreateType;
import org.apache.calcite.sql.ddl.SqlCreateView;
import org.apache.calcite.sql.ddl.SqlDropObject;
import org.apache.calcite.sql.ddl.SqlDropSchema;
import org.apache.calcite.sql.dialect.CalciteSqlDialect;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlAbstractParserImpl;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.sql.parser.SqlParserImplFactory;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.parser.ddl.SqlDdlParserImpl;
import org.apache.calcite.sql.pretty.SqlPrettyWriter;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql2rel.InitializerContext;
import org.apache.calcite.sql2rel.InitializerExpressionFactory;
import org.apache.calcite.sql2rel.NullInitializerExpressionFactory;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.calcite.tools.Frameworks;
import org.apache.calcite.tools.Planner;
import org.apache.calcite.tools.RelConversionException;
import org.apache.calcite.tools.ValidationException;
import org.apache.calcite.util.NlsString;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Static;
import org.apache.calcite.util.Util;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ServerDdlExecutor
extends DdlExecutorImpl {
    public static final ServerDdlExecutor INSTANCE = new ServerDdlExecutor();
    public static final SqlParserImplFactory PARSER_FACTORY = new SqlParserImplFactory(){

        public SqlAbstractParserImpl getParser(Reader stream) {
            return SqlDdlParserImpl.FACTORY.getParser(stream);
        }

        public DdlExecutor getDdlExecutor() {
            return INSTANCE;
        }
    };

    protected ServerDdlExecutor() {
    }

    static Pair<CalciteSchema, String> schema(CalcitePrepare.Context context, boolean mutable, SqlIdentifier id) {
        String name;
        List path;
        if (id.isSimple()) {
            path = context.getDefaultSchemaPath();
            name = id.getSimple();
        } else {
            path = Util.skipLast((List)id.names);
            name = (String)Util.last((List)id.names);
        }
        CalciteSchema schema = mutable ? context.getMutableRootSchema() : context.getRootSchema();
        for (String p : path) {
            schema = schema.getSubSchema(p, true);
        }
        return Pair.of((Object)schema, (Object)name);
    }

    static SqlValidator validator(CalcitePrepare.Context context, boolean mutable) {
        return new ContextSqlValidator(context, mutable);
    }

    static SqlNode renameColumns(@Nullable SqlNodeList columnList, SqlNode query) {
        if (columnList == null) {
            return query;
        }
        SqlParserPos p = query.getParserPosition();
        SqlNodeList selectList = SqlNodeList.SINGLETON_STAR;
        SqlCall from = SqlStdOperatorTable.AS.createCall(p, (List)ImmutableList.builder().add((Object)query).add((Object)new SqlIdentifier("_", p)).addAll((Iterable)columnList).build());
        return new SqlSelect(p, null, selectList, (SqlNode)from, null, null, null, null, null, null, null, null, null);
    }

    static void populate(SqlIdentifier name, SqlNode query, CalcitePrepare.Context context) {
        FrameworkConfig config = Frameworks.newConfigBuilder().defaultSchema(context.getRootSchema().plus()).build();
        Planner planner = Frameworks.getPlanner((FrameworkConfig)config);
        try {
            StringBuilder buf = new StringBuilder();
            SqlWriterConfig writerConfig = SqlPrettyWriter.config().withAlwaysUseParentheses(false);
            SqlPrettyWriter w = new SqlPrettyWriter(writerConfig, buf);
            buf.append("INSERT INTO ");
            name.unparse((SqlWriter)w, 0, 0);
            buf.append(' ');
            query.unparse((SqlWriter)w, 0, 0);
            String sql = buf.toString();
            SqlNode query1 = planner.parse(sql);
            SqlNode query2 = planner.validate(query1);
            RelRoot r = planner.rel(query2);
            PreparedStatement prepare = context.getRelRunner().prepareStatement(r.rel);
            int rowCount = prepare.executeUpdate();
            Util.discard((int)rowCount);
            prepare.close();
        }
        catch (SQLException | SqlParseException | RelConversionException | ValidationException e) {
            throw Util.throwAsRuntime((Throwable)e);
        }
    }

    static Comparable value(SqlNode node) {
        Comparable v = SqlLiteral.value((SqlNode)node);
        return v instanceof NlsString ? ((NlsString)v).getValue() : v;
    }

    public void execute(SqlCreateForeignSchema create, CalcitePrepare.Context context) {
        String libraryName;
        Pair<CalciteSchema, String> pair = ServerDdlExecutor.schema(context, true, create.name);
        SchemaPlus subSchema0 = ((CalciteSchema)pair.left).plus().getSubSchema((String)pair.right);
        if (subSchema0 != null && !create.getReplace() && !create.ifNotExists) {
            throw SqlUtil.newContextException((SqlParserPos)create.name.getParserPosition(), (Resources.ExInst)Static.RESOURCE.schemaExists((String)pair.right));
        }
        if (create.type != null) {
            Preconditions.checkArgument((create.library == null ? 1 : 0) != 0);
            String typeName = (String)((Object)ServerDdlExecutor.value(create.type));
            JsonSchema.Type type = (JsonSchema.Type)Util.enumVal(JsonSchema.Type.class, (String)typeName.toUpperCase(Locale.ROOT));
            if (type != null) {
                switch (type) {
                    case JDBC: {
                        libraryName = JdbcSchema.Factory.class.getName();
                        break;
                    }
                    default: {
                        libraryName = null;
                        break;
                    }
                }
            } else {
                libraryName = null;
            }
            if (libraryName == null) {
                throw SqlUtil.newContextException((SqlParserPos)create.type.getParserPosition(), (Resources.ExInst)Static.RESOURCE.schemaInvalidType(typeName, Arrays.toString(JsonSchema.Type.values())));
            }
        } else {
            Preconditions.checkArgument((create.library != null ? 1 : 0) != 0);
            libraryName = (String)((Object)ServerDdlExecutor.value(create.library));
        }
        SchemaFactory schemaFactory = (SchemaFactory)AvaticaUtils.instantiatePlugin(SchemaFactory.class, (String)libraryName);
        LinkedHashMap<String, Comparable> operandMap = new LinkedHashMap<String, Comparable>();
        for (Pair option : create.options()) {
            operandMap.put(((SqlIdentifier)option.left).getSimple(), ServerDdlExecutor.value((SqlNode)option.right));
        }
        Schema subSchema = schemaFactory.create(((CalciteSchema)pair.left).plus(), (String)pair.right, operandMap);
        ((CalciteSchema)pair.left).add((String)pair.right, subSchema);
    }

    public void execute(SqlCreateFunction create, CalcitePrepare.Context context) {
        throw new UnsupportedOperationException("CREATE FUNCTION is not supported");
    }

    public void execute(SqlDropObject drop, CalcitePrepare.Context context) {
        Pair<CalciteSchema, String> pair = ServerDdlExecutor.schema(context, false, drop.name);
        CalciteSchema schema = (CalciteSchema)pair.left;
        String objectName = (String)pair.right;
        assert (objectName != null);
        boolean schemaExists = schema != null;
        switch (drop.getKind()) {
            case DROP_TABLE: 
            case DROP_MATERIALIZED_VIEW: {
                boolean existed;
                Table materializedView = schemaExists && drop.getKind() == SqlKind.DROP_MATERIALIZED_VIEW ? schema.plus().getTable(objectName) : null;
                boolean bl = existed = schemaExists && schema.removeTable(objectName);
                if (existed) {
                    if (!(materializedView instanceof Wrapper)) break;
                    ((Wrapper)materializedView).maybeUnwrap(MaterializationKey.class).ifPresent(materializationKey -> MaterializationService.instance().removeMaterialization(materializationKey));
                    break;
                }
                if (drop.ifExists) break;
                throw SqlUtil.newContextException((SqlParserPos)drop.name.getParserPosition(), (Resources.ExInst)Static.RESOURCE.tableNotFound(objectName));
            }
            case DROP_VIEW: {
                boolean existed;
                boolean bl = existed = schemaExists && schema.removeFunction(objectName);
                if (existed || drop.ifExists) break;
                throw SqlUtil.newContextException((SqlParserPos)drop.name.getParserPosition(), (Resources.ExInst)Static.RESOURCE.viewNotFound(objectName));
            }
            case DROP_TYPE: {
                boolean existed;
                boolean bl = existed = schemaExists && schema.removeType(objectName);
                if (existed || drop.ifExists) break;
                throw SqlUtil.newContextException((SqlParserPos)drop.name.getParserPosition(), (Resources.ExInst)Static.RESOURCE.typeNotFound(objectName));
            }
            case DROP_FUNCTION: {
                boolean existed;
                boolean bl = existed = schemaExists && schema.removeFunction(objectName);
                if (existed || drop.ifExists) break;
                throw SqlUtil.newContextException((SqlParserPos)drop.name.getParserPosition(), (Resources.ExInst)Static.RESOURCE.functionNotFound(objectName));
            }
            default: {
                throw new AssertionError(drop.getKind());
            }
        }
    }

    public void execute(SqlCreateMaterializedView create, CalcitePrepare.Context context) {
        Pair<CalciteSchema, String> pair = ServerDdlExecutor.schema(context, true, create.name);
        if (((CalciteSchema)pair.left).plus().getTable((String)pair.right) != null) {
            if (!create.ifNotExists) {
                throw SqlUtil.newContextException((SqlParserPos)create.name.getParserPosition(), (Resources.ExInst)Static.RESOURCE.tableExists((String)pair.right));
            }
            return;
        }
        SqlNode q = ServerDdlExecutor.renameColumns(create.columnList, create.query);
        String sql = q.toSqlString(CalciteSqlDialect.DEFAULT).getSql();
        List schemaPath = ((CalciteSchema)pair.left).path(null);
        ViewTableMacro viewTableMacro = ViewTable.viewMacro((SchemaPlus)((CalciteSchema)pair.left).plus(), (String)sql, (List)schemaPath, (List)context.getObjectPath(), (Boolean)false);
        TranslatableTable x = viewTableMacro.apply((List)ImmutableList.of());
        RelDataType rowType = x.getRowType((RelDataTypeFactory)context.getTypeFactory());
        MaterializedViewTable table = new MaterializedViewTable((String)pair.right, RelDataTypeImpl.proto((RelDataType)rowType));
        ((CalciteSchema)pair.left).add((String)pair.right, (Table)table);
        ServerDdlExecutor.populate(create.name, create.query, context);
        table.key = MaterializationService.instance().defineMaterialization((CalciteSchema)pair.left, null, sql, schemaPath, (String)pair.right, true, true);
    }

    public void execute(SqlCreateSchema create, CalcitePrepare.Context context) {
        Pair<CalciteSchema, String> pair = ServerDdlExecutor.schema(context, true, create.name);
        SchemaPlus subSchema0 = ((CalciteSchema)pair.left).plus().getSubSchema((String)pair.right);
        if (subSchema0 != null) {
            if (create.ifNotExists) {
                return;
            }
            if (!create.getReplace()) {
                throw SqlUtil.newContextException((SqlParserPos)create.name.getParserPosition(), (Resources.ExInst)Static.RESOURCE.schemaExists((String)pair.right));
            }
        }
        AbstractSchema subSchema = new AbstractSchema();
        ((CalciteSchema)pair.left).add((String)pair.right, (Schema)subSchema);
    }

    public void execute(SqlDropSchema drop, CalcitePrepare.Context context) {
        boolean existed;
        Pair<CalciteSchema, String> pair = ServerDdlExecutor.schema(context, false, drop.name);
        boolean bl = existed = pair.left != null && ((CalciteSchema)pair.left).removeSubSchema((String)pair.right);
        if (!existed && !drop.ifExists) {
            throw SqlUtil.newContextException((SqlParserPos)drop.name.getParserPosition(), (Resources.ExInst)Static.RESOURCE.schemaNotFound((String)pair.right));
        }
    }

    public void execute(SqlCreateTable create, CalcitePrepare.Context context) {
        Object columnList;
        RelDataType queryRowType;
        Pair<CalciteSchema, String> pair = ServerDdlExecutor.schema(context, true, create.name);
        JavaTypeFactory typeFactory = context.getTypeFactory();
        if (create.query != null) {
            String sql = create.query.toSqlString(CalciteSqlDialect.DEFAULT).getSql();
            ViewTableMacro viewTableMacro = ViewTable.viewMacro((SchemaPlus)((CalciteSchema)pair.left).plus(), (String)sql, (List)((CalciteSchema)pair.left).path(null), (List)context.getObjectPath(), (Boolean)false);
            TranslatableTable x = viewTableMacro.apply((List)ImmutableList.of());
            queryRowType = x.getRowType((RelDataTypeFactory)typeFactory);
            if (create.columnList != null && queryRowType.getFieldCount() != create.columnList.size()) {
                throw SqlUtil.newContextException((SqlParserPos)create.columnList.getParserPosition(), (Resources.ExInst)Static.RESOURCE.columnCountMismatch());
            }
        } else {
            queryRowType = null;
        }
        if (create.columnList != null) {
            columnList = create.columnList;
        } else {
            if (queryRowType == null) {
                throw SqlUtil.newContextException((SqlParserPos)create.name.getParserPosition(), (Resources.ExInst)Static.RESOURCE.createTableRequiresColumnList());
            }
            columnList = new ArrayList();
            for (String name : queryRowType.getFieldNames()) {
                columnList.add(new SqlIdentifier(name, SqlParserPos.ZERO));
            }
        }
        ImmutableList.Builder b = ImmutableList.builder();
        RelDataTypeFactory.FieldInfoBuilder builder = typeFactory.builder();
        RelDataTypeFactory.FieldInfoBuilder storedBuilder = typeFactory.builder();
        SqlValidator validator = ServerDdlExecutor.validator(context, true);
        for (Ord c : Ord.zip((List)columnList)) {
            if (c.e instanceof SqlColumnDeclaration) {
                SqlColumnDeclaration d = (SqlColumnDeclaration)c.e;
                RelDataType type = d.dataType.deriveType(validator, true);
                builder.add(d.name.getSimple(), type);
                if (d.strategy != ColumnStrategy.VIRTUAL) {
                    storedBuilder.add(d.name.getSimple(), type);
                }
                b.add((Object)ColumnDef.of(d.expression, type, d.strategy));
                continue;
            }
            if (c.e instanceof SqlIdentifier) {
                SqlIdentifier id = (SqlIdentifier)c.e;
                if (queryRowType == null) {
                    throw SqlUtil.newContextException((SqlParserPos)id.getParserPosition(), (Resources.ExInst)Static.RESOURCE.createTableRequiresColumnTypes(id.getSimple()));
                }
                RelDataTypeField f = (RelDataTypeField)queryRowType.getFieldList().get(c.i);
                ColumnStrategy strategy = f.getType().isNullable() ? ColumnStrategy.NULLABLE : ColumnStrategy.NOT_NULLABLE;
                b.add((Object)ColumnDef.of((SqlNode)c.e, f.getType(), strategy));
                builder.add(id.getSimple(), f.getType());
                storedBuilder.add(id.getSimple(), f.getType());
                continue;
            }
            throw new AssertionError(((SqlNode)c.e).getClass());
        }
        RelDataType rowType = builder.build();
        RelDataType storedRowType = storedBuilder.build();
        ImmutableList columns = b.build();
        NullInitializerExpressionFactory ief = new NullInitializerExpressionFactory((List)columns, storedRowType){
            final /* synthetic */ List val$columns;
            final /* synthetic */ RelDataType val$storedRowType;
            {
                this.val$columns = list;
                this.val$storedRowType = relDataType;
            }

            public ColumnStrategy generationStrategy(RelOptTable table, int iColumn) {
                return ((ColumnDef)this.val$columns.get((int)iColumn)).strategy;
            }

            public RexNode newColumnDefaultValue(RelOptTable table, int iColumn, InitializerContext context) {
                ColumnDef c = (ColumnDef)this.val$columns.get(iColumn);
                if (c.expr != null) {
                    SqlNode validated = context.validateExpression(this.val$storedRowType, c.expr);
                    return context.convertExpression(validated);
                }
                return super.newColumnDefaultValue(table, iColumn, context);
            }
        };
        if (((CalciteSchema)pair.left).plus().getTable((String)pair.right) != null) {
            if (create.ifNotExists) {
                return;
            }
            if (!create.getReplace()) {
                throw SqlUtil.newContextException((SqlParserPos)create.name.getParserPosition(), (Resources.ExInst)Static.RESOURCE.tableExists((String)pair.right));
            }
        }
        ((CalciteSchema)pair.left).add((String)pair.right, (Table)new MutableArrayTable((String)pair.right, RelDataTypeImpl.proto((RelDataType)storedRowType), RelDataTypeImpl.proto((RelDataType)rowType), (InitializerExpressionFactory)ief));
        if (create.query != null) {
            ServerDdlExecutor.populate(create.name, create.query, context);
        }
    }

    public void execute(SqlCreateType create, CalcitePrepare.Context context) {
        Pair<CalciteSchema, String> pair = ServerDdlExecutor.schema(context, true, create.name);
        SqlValidator validator = ServerDdlExecutor.validator(context, false);
        ((CalciteSchema)pair.left).add((String)pair.right, typeFactory -> {
            if (create.dataType != null) {
                return create.dataType.deriveType(validator);
            }
            RelDataTypeFactory.FieldInfoBuilder builder = typeFactory.builder();
            for (SqlNode def : create.attributeDefs) {
                SqlAttributeDefinition attributeDef = (SqlAttributeDefinition)def;
                SqlDataTypeSpec typeSpec = attributeDef.dataType;
                RelDataType type = typeSpec.deriveType(validator);
                builder.add(attributeDef.name.getSimple(), type);
            }
            return builder.build();
        });
    }

    public void execute(SqlCreateView create, CalcitePrepare.Context context) {
        Pair<CalciteSchema, String> pair = ServerDdlExecutor.schema(context, true, create.name);
        SchemaPlus schemaPlus = ((CalciteSchema)pair.left).plus();
        for (Function function : schemaPlus.getFunctions((String)pair.right)) {
            if (!function.getParameters().isEmpty()) continue;
            if (!create.getReplace()) {
                throw SqlUtil.newContextException((SqlParserPos)create.name.getParserPosition(), (Resources.ExInst)Static.RESOURCE.viewExists((String)pair.right));
            }
            ((CalciteSchema)pair.left).removeFunction((String)pair.right);
        }
        SqlNode q = ServerDdlExecutor.renameColumns(create.columnList, create.query);
        String sql = q.toSqlString(CalciteSqlDialect.DEFAULT).getSql();
        ViewTableMacro viewTableMacro = ViewTable.viewMacro((SchemaPlus)schemaPlus, (String)sql, (List)((CalciteSchema)pair.left).path(null), (List)context.getObjectPath(), (Boolean)false);
        TranslatableTable x = viewTableMacro.apply((List)ImmutableList.of());
        Util.discard((Object)x);
        schemaPlus.add((String)pair.right, (Function)viewTableMacro);
    }

    private static class ColumnDef {
        final SqlNode expr;
        final RelDataType type;
        final ColumnStrategy strategy;

        private ColumnDef(SqlNode expr, RelDataType type, ColumnStrategy strategy) {
            this.expr = expr;
            this.type = type;
            this.strategy = Objects.requireNonNull(strategy, "strategy");
            Preconditions.checkArgument((strategy == ColumnStrategy.NULLABLE || strategy == ColumnStrategy.NOT_NULLABLE || expr != null ? 1 : 0) != 0);
        }

        static ColumnDef of(SqlNode expr, RelDataType type, ColumnStrategy strategy) {
            return new ColumnDef(expr, type, strategy);
        }
    }
}

