/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.Set;
import org.jooq.Context;
import org.jooq.Field;
import org.jooq.SQLDialect;
import org.jooq.impl.AbstractField;
import org.jooq.impl.ExpressionOperator;

final class Neg<T>
extends AbstractField<T> {
    private static final long serialVersionUID = 7624782102883057433L;
    private static final Set<SQLDialect> EMULATE_BIT_NOT = SQLDialect.supportedBy(SQLDialect.HSQLDB);
    private static final Set<SQLDialect> SUPPORT_BIT_NOT = SQLDialect.supportedBy(SQLDialect.H2);
    private final ExpressionOperator operator;
    private final Field<T> field;

    Neg(Field<T> field, ExpressionOperator operator) {
        super(operator.toName(), field.getDataType());
        this.operator = operator;
        this.field = field;
    }

    @Override
    public final void accept(Context<?> ctx) {
        SQLDialect family = ctx.family();
        if (this.operator == ExpressionOperator.BIT_NOT && EMULATE_BIT_NOT.contains((Object)family)) {
            ctx.sql("(0 - ").visit(this.field).sql(" - 1)");
        } else if (this.operator == ExpressionOperator.BIT_NOT && SUPPORT_BIT_NOT.contains((Object)family)) {
            ctx.sql("bitnot(").visit(this.field).sql(')');
        } else if (this.operator == ExpressionOperator.BIT_NOT && family == SQLDialect.FIREBIRD) {
            ctx.sql("bin_not(").visit(this.field).sql(')');
        } else {
            ctx.sql(this.operator.toSQL()).sql('(').visit(this.field).sql(')');
        }
    }
}

